/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.geo.IBSplineBasisFunction;
import igeo.geo.IBool;
import igeo.geo.ICurveI;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.IEntityParameter;
import igeo.geo.IInteger;
import igeo.geo.IIntegerI;
import igeo.geo.INurbsGeo;
import igeo.geo.ISurfaceI;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.ITrimCurve;
import igeo.geo.ITrimCurveI;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.geo.IVec2I;
import igeo.geo.IVec4;
import igeo.geo.IVec4I;
import igeo.geo.IVecI;
import igeo.gui.IPolyline2D;
import igeo.gui.ITrimCurveGraphic;
import igeo.gui.ITrimLoopGraphic;
import java.util.ArrayList;

public class ISurfaceGeo
extends INurbsGeo
implements ISurfaceI,
IEntityParameter {
    public IVecI[][] controlPoints;
    public int udegree;
    public int vdegree;
    public double[] uknots;
    public double[] vknots;
    public double ustart;
    public double uend;
    public double vstart;
    public double vend;
    public boolean[][] defaultWeights;
    public IBSplineBasisFunction basisFunctionU;
    public IBSplineBasisFunction basisFunctionV;
    public IBSplineBasisFunction derivativeFunctionU;
    public IBSplineBasisFunction derivativeFunctionV;
    public ArrayList<ArrayList<ITrimCurve>> innerTrimLoop;
    public ArrayList<ArrayList<ITrimCurve>> outerTrimLoop;
    public boolean innerTrimClosed = false;
    public boolean outerTrimClosed = false;

    public ISurfaceGeo() {
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        this.ustart = d;
        this.uend = d2;
        this.vstart = d3;
        this.vend = d4;
        if (d != 0.0 || d2 != 0.0) {
            ISurfaceGeo.normalizeKnots(dArray, d, d2);
        }
        if (d3 != 0.0 || d4 != 0.0) {
            ISurfaceGeo.normalizeKnots(dArray2, d3, d4);
        }
        this.init(iVecIArray, n, n2, dArray, dArray2);
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        this.ustart = dArray[0];
        this.uend = dArray[dArray.length - 1];
        this.vstart = dArray2[0];
        this.vend = dArray2[dArray2.length - 1];
        if (dArray[0] != 0.0 || dArray[dArray.length - 1] != 1.0) {
            ISurfaceGeo.normalizeKnots(dArray, dArray[0], dArray[dArray.length - 1]);
        }
        if (dArray2[0] != 0.0 || dArray2[dArray2.length - 1] != 1.0) {
            ISurfaceGeo.normalizeKnots(dArray2, dArray2[0], dArray2[dArray2.length - 1]);
        }
        this.init(iVecIArray, n, n2, dArray, dArray2);
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, n, n2, ISurfaceGeo.createKnots(n, iVecIArray.length), ISurfaceGeo.createKnots(n2, iVecIArray[0].length));
    }

    public ISurfaceGeo(IVecI[][] iVecIArray) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, 1, 1, ISurfaceGeo.createKnots(1, iVecIArray.length), ISurfaceGeo.createKnots(1, iVecIArray[0].length));
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, n, n2, bl, bl2);
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, n, n2, bl, dArray);
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, n, n2, dArray, bl);
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, 1, 1, bl, bl2);
    }

    public ISurfaceGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        IVecI[][] iVecIArray = new IVecI[2][2];
        iVecIArray[0][0] = iVecI;
        iVecIArray[1][0] = iVecI2;
        iVecIArray[1][1] = iVecI3;
        iVecIArray[0][1] = iVecI4;
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, 1, 1, ISurfaceGeo.createKnots(1, 2), ISurfaceGeo.createKnots(1, 2));
    }

    public ISurfaceGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this(iVecI, iVecI2, iVecI3, iVecI);
    }

    public ISurfaceGeo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this(new IVec(d, d2, d3), new IVec(d4, d5, d6), new IVec(d7, d8, d9), new IVec(d10, d11, d12));
    }

    public ISurfaceGeo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this(new IVec(d, d2, d3), new IVec(d4, d5, d6), new IVec(d7, d8, d9));
    }

    public ISurfaceGeo(double[][][] dArray) {
        this(ISurfaceGeo.getPointsFromArray(dArray));
    }

    public ISurfaceGeo(double[][][] dArray, int n, int n2) {
        this((IVecI[][])ISurfaceGeo.getPointsFromArray(dArray), n, n2);
    }

    public ISurfaceGeo(double[][][] dArray, boolean bl, boolean bl2) {
        this((IVecI[][])ISurfaceGeo.getPointsFromArray(dArray), bl, bl2);
    }

    public ISurfaceGeo(double[][][] dArray, int n, int n2, boolean bl, boolean bl2) {
        this((IVecI[][])ISurfaceGeo.getPointsFromArray(dArray), n, n2, bl, bl2);
    }

    public ISurfaceGeo(ISurfaceGeo iSurfaceGeo) {
        int n;
        int n2;
        this.controlPoints = new IVecI[iSurfaceGeo.controlPoints.length][iSurfaceGeo.controlPoints[0].length];
        for (n2 = 0; n2 < this.controlPoints.length; ++n2) {
            for (int i = 0; i < this.controlPoints[0].length; ++i) {
                this.controlPoints[n2][i] = iSurfaceGeo.controlPoints[n2][i].dup();
            }
        }
        this.uknots = new double[iSurfaceGeo.uknots.length];
        System.arraycopy(iSurfaceGeo.uknots, 0, this.uknots, 0, this.uknots.length);
        this.vknots = new double[iSurfaceGeo.vknots.length];
        System.arraycopy(iSurfaceGeo.vknots, 0, this.vknots, 0, this.vknots.length);
        this.udegree = iSurfaceGeo.udegree;
        this.vdegree = iSurfaceGeo.vdegree;
        this.ustart = iSurfaceGeo.ustart;
        this.uend = iSurfaceGeo.uend;
        this.vstart = iSurfaceGeo.vstart;
        this.vend = iSurfaceGeo.vend;
        this.init(this.controlPoints, this.udegree, this.vdegree, this.uknots, this.vknots);
        if (iSurfaceGeo.innerTrimLoop != null) {
            this.innerTrimLoop = new ArrayList();
            for (n2 = 0; n2 < iSurfaceGeo.innerTrimLoop.size(); ++n2) {
                ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
                for (n = 0; n < iSurfaceGeo.innerTrimLoop.get(n2).size(); ++n) {
                    arrayList.add(new ITrimCurve(iSurfaceGeo.innerTrimLoop.get(n2).get(n)).surface(this));
                }
                this.innerTrimLoop.add(arrayList);
            }
        }
        if (iSurfaceGeo.outerTrimLoop != null) {
            this.outerTrimLoop = new ArrayList();
            for (n2 = 0; n2 < iSurfaceGeo.outerTrimLoop.size(); ++n2) {
                ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
                for (n = 0; n < iSurfaceGeo.outerTrimLoop.get(n2).size(); ++n) {
                    arrayList.add(new ITrimCurve(iSurfaceGeo.outerTrimLoop.get(n2).get(n)).surface(this));
                }
                this.outerTrimLoop.add(arrayList);
            }
        }
    }

    public void init(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        if (bl && bl2) {
            int n3;
            IVecI[][] iVecIArrayArray = new IVecI[iVecIArray.length][];
            for (int i = 0; i < iVecIArray.length; ++i) {
                iVecIArrayArray[i] = ISurfaceGeo.createClosedControlPoints(iVecIArray[i], n2);
            }
            IVecI[][] iVecIArray2 = new IVecI[iVecIArrayArray[0].length][iVecIArrayArray.length];
            for (int i = 0; i < iVecIArrayArray[0].length; ++i) {
                for (n3 = 0; n3 < iVecIArrayArray.length; ++n3) {
                    iVecIArray2[i][n3] = iVecIArrayArray[n3][i];
                }
            }
            IVecI[][] iVecIArrayArray2 = new IVecI[iVecIArrayArray[0].length][];
            for (n3 = 0; n3 < iVecIArrayArray[0].length; ++n3) {
                iVecIArrayArray2[n3] = ISurfaceGeo.createClosedControlPoints(iVecIArray2[n3], n);
            }
            IVecI[][] iVecIArray3 = new IVecI[iVecIArrayArray2[0].length][iVecIArrayArray[0].length];
            for (int i = 0; i < iVecIArray3.length; ++i) {
                for (int j = 0; j < iVecIArray3[0].length; ++j) {
                    iVecIArray3[i][j] = iVecIArrayArray2[j][i];
                }
            }
            this.init(iVecIArray3, n, n2, ISurfaceGeo.createClosedKnots(n, iVecIArray3.length), ISurfaceGeo.createClosedKnots(n2, iVecIArray3[0].length));
        } else if (bl) {
            this.init(iVecIArray, n, n2, bl, ISurfaceGeo.createKnots(n2, iVecIArray[0].length));
        } else if (bl2) {
            this.init(iVecIArray, n, n2, ISurfaceGeo.createKnots(n, iVecIArray.length), bl2);
        } else {
            this.init(iVecIArray, this.udegree, this.vdegree, ISurfaceGeo.createKnots(this.udegree, iVecIArray.length), ISurfaceGeo.createKnots(this.vdegree, iVecIArray[0].length));
        }
    }

    public void init(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        if (bl) {
            IVecI[][] iVecIArray2 = new IVecI[iVecIArray.length][];
            for (int i = 0; i < iVecIArray.length; ++i) {
                iVecIArray2[i] = ISurfaceGeo.createClosedControlPoints(iVecIArray[i], n2);
            }
            this.init(iVecIArray2, n, n2, dArray, ISurfaceGeo.createClosedKnots(n2, iVecIArray2[0].length));
        } else {
            this.init(iVecIArray, n, n2, dArray, ISurfaceGeo.createKnots(n2, iVecIArray[0].length));
        }
    }

    public void init(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        if (bl) {
            int n3;
            IVecI[][] iVecIArray2 = new IVecI[iVecIArray[0].length][iVecIArray.length];
            for (int i = 0; i < iVecIArray[0].length; ++i) {
                for (n3 = 0; n3 < iVecIArray.length; ++n3) {
                    iVecIArray2[i][n3] = iVecIArray[n3][i];
                }
            }
            IVecI[][] iVecIArrayArray = new IVecI[iVecIArray[0].length][];
            for (n3 = 0; n3 < iVecIArray[0].length; ++n3) {
                iVecIArrayArray[n3] = ISurfaceGeo.createClosedControlPoints(iVecIArray2[n3], n);
            }
            IVecI[][] iVecIArray3 = new IVecI[iVecIArrayArray[0].length][iVecIArray[0].length];
            for (int i = 0; i < iVecIArray3.length; ++i) {
                for (int j = 0; j < iVecIArray3[0].length; ++j) {
                    iVecIArray3[i][j] = iVecIArrayArray[j][i];
                }
            }
            this.init(iVecIArray3, n, n2, ISurfaceGeo.createClosedKnots(n, iVecIArray3.length), dArray);
        } else {
            this.init(iVecIArray, n, n2, ISurfaceGeo.createKnots(n, iVecIArray.length), dArray);
        }
    }

    public void init(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        this.controlPoints = iVecIArray;
        this.udegree = n;
        this.vdegree = n2;
        this.uknots = dArray;
        this.vknots = dArray2;
        this.basisFunctionU = new IBSplineBasisFunction(n, dArray);
        this.basisFunctionV = new IBSplineBasisFunction(n2, dArray2);
        this.defaultWeights = new boolean[iVecIArray.length][iVecIArray[0].length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = 0; j < iVecIArray[0].length; ++j) {
                this.defaultWeights[i][j] = !(iVecIArray[i][j] instanceof IVec4I);
            }
        }
    }

    public static IVec[][] getPointsFromArray(double[][][] dArray) {
        IVec[][] iVecArray = new IVec[dArray.length][dArray[0].length];
        for (int i = 0; i < iVecArray.length; ++i) {
            for (int j = 0; j < iVecArray[0].length; ++j) {
                if (dArray[i][j].length == 4) {
                    iVecArray[i][j] = new IVec4(dArray[i][j][0], dArray[i][j][1], dArray[i][j][2], dArray[i][j][3]);
                    continue;
                }
                iVecArray[i][j] = new IVec();
                if (dArray[i][j].length >= 1) {
                    iVecArray[i][j].x = dArray[i][j][0];
                }
                if (dArray[i][j].length >= 2) {
                    iVecArray[i][j].y = dArray[i][j][1];
                }
                if (dArray[i][j].length < 3) continue;
                iVecArray[i][j].z = dArray[i][j][2];
            }
        }
        return iVecArray;
    }

    public ISurfaceGeo get() {
        return this;
    }

    public ISurfaceGeo dup() {
        return new ISurfaceGeo(this);
    }

    public IVec pt(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.pt(iVec2.x, iVec2.y);
    }

    public IVec pt(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.pt(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec pt(double d, double d2) {
        IVec iVec = new IVec();
        this.pt(d, d2, iVec);
        return iVec;
    }

    public void pt(double d, double d2, IVec iVec) {
        int n = this.basisFunctionU.index(d);
        int n2 = this.basisFunctionV.index(d2);
        double[] dArray = this.basisFunctionU.eval(n, d);
        double[] dArray2 = this.basisFunctionV.eval(n2, d2);
        double d3 = 0.0;
        for (int i = 0; i <= this.udegree; ++i) {
            for (int j = 0; j <= this.vdegree; ++j) {
                IVec iVec2 = this.controlPoints[n - this.udegree + i][n2 - this.vdegree + j].get();
                double d4 = 1.0;
                if (!this.defaultWeights[n - this.udegree + i][n2 - this.vdegree + j]) {
                    d4 = ((IVec4)iVec2).w;
                }
                iVec.x += iVec2.x * d4 * dArray[i] * dArray2[j];
                iVec.y += iVec2.y * d4 * dArray[i] * dArray2[j];
                iVec.z += iVec2.z * d4 * dArray[i] * dArray2[j];
                d3 += d4 * dArray[i] * dArray2[j];
            }
        }
        iVec.x /= d3;
        iVec.y /= d3;
        iVec.z /= d3;
    }

    public IVec pt(double d, double d2, double d3) {
        IVec iVec = new IVec();
        this.pt(d, d2, iVec);
        return iVec.add(this.nrml(d, d2).len(d3));
    }

    public IVec pt(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.pt(iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x());
    }

    public IVec pt(IVec iVec) {
        return this.pt(iVec.x, iVec.y, iVec.z);
    }

    public IVec pt(IVecI iVecI) {
        IVec iVec = iVecI.get();
        return this.pt(iVec.x, iVec.y, iVec.z);
    }

    public IVec utan(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.utan(iVec2.x, iVec2.y);
    }

    public IVec utan(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.utan(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec utan(double d, double d2) {
        IVec iVec = new IVec();
        this.utan(d, d2, iVec);
        return iVec;
    }

    public void utan(double d, double d2, IVec iVec) {
        if (this.derivativeFunctionU == null) {
            this.derivativeFunctionU = new IBSplineBasisFunction(this.basisFunctionU);
            this.derivativeFunctionU.differentiate();
        }
        int n = this.basisFunctionU.index(d);
        int n2 = this.basisFunctionV.index(d2);
        double[] dArray = this.basisFunctionU.eval(n, d);
        double[] dArray2 = this.basisFunctionV.eval(n2, d2);
        double[] dArray3 = this.derivativeFunctionU.eval(n, d);
        IVec4 iVec4 = new IVec4();
        IVec4 iVec42 = new IVec4();
        for (int i = 0; i <= this.udegree; ++i) {
            for (int j = 0; j <= this.vdegree; ++j) {
                IVec iVec2 = this.controlPoints[n - this.udegree + i][n2 - this.vdegree + j].get();
                double d3 = 1.0;
                if (!this.defaultWeights[n - this.udegree + i][n2 - this.vdegree + j]) {
                    d3 = ((IVec4)iVec2).w;
                }
                iVec4.x += iVec2.x * d3 * dArray[i] * dArray2[j];
                iVec4.y += iVec2.y * d3 * dArray[i] * dArray2[j];
                iVec4.z += iVec2.z * d3 * dArray[i] * dArray2[j];
                iVec4.w += d3 * dArray[i] * dArray2[j];
                iVec42.x += iVec2.x * d3 * dArray3[i] * dArray2[j];
                iVec42.y += iVec2.y * d3 * dArray3[i] * dArray2[j];
                iVec42.z += iVec2.z * d3 * dArray3[i] * dArray2[j];
                iVec42.w += d3 * dArray3[i] * dArray2[j];
            }
        }
        iVec4.x *= iVec42.w;
        iVec4.y *= iVec42.w;
        iVec4.z *= iVec42.w;
        iVec42.x *= iVec4.w;
        iVec42.y *= iVec4.w;
        iVec42.z *= iVec4.w;
        iVec4.w *= iVec4.w;
        iVec.x = (iVec42.x - iVec4.x) / iVec4.w;
        iVec.y = (iVec42.y - iVec4.y) / iVec4.w;
        iVec.z = (iVec42.z - iVec4.z) / iVec4.w;
    }

    public IVec vtan(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.vtan(iVec2.x, iVec2.y);
    }

    public IVec vtan(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.vtan(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec vtan(double d, double d2) {
        IVec iVec = new IVec();
        this.vtan(d, d2, iVec);
        return iVec;
    }

    public void vtan(double d, double d2, IVec iVec) {
        if (this.derivativeFunctionV == null) {
            this.derivativeFunctionV = new IBSplineBasisFunction(this.basisFunctionV);
            this.derivativeFunctionV.differentiate();
        }
        int n = this.basisFunctionU.index(d);
        int n2 = this.basisFunctionV.index(d2);
        double[] dArray = this.basisFunctionU.eval(n, d);
        double[] dArray2 = this.basisFunctionV.eval(n2, d2);
        double[] dArray3 = this.derivativeFunctionV.eval(n2, d2);
        IVec4 iVec4 = new IVec4();
        IVec4 iVec42 = new IVec4();
        for (int i = 0; i <= this.udegree; ++i) {
            for (int j = 0; j <= this.vdegree; ++j) {
                IVec iVec2 = this.controlPoints[n - this.udegree + i][n2 - this.vdegree + j].get();
                double d3 = 1.0;
                if (!this.defaultWeights[n - this.udegree + i][n2 - this.vdegree + j]) {
                    d3 = ((IVec4)iVec2).w;
                }
                iVec4.x += iVec2.x * d3 * dArray[i] * dArray2[j];
                iVec4.y += iVec2.y * d3 * dArray[i] * dArray2[j];
                iVec4.z += iVec2.z * d3 * dArray[i] * dArray2[j];
                iVec4.w += d3 * dArray[i] * dArray2[j];
                iVec42.x += iVec2.x * d3 * dArray[i] * dArray3[j];
                iVec42.y += iVec2.y * d3 * dArray[i] * dArray3[j];
                iVec42.z += iVec2.z * d3 * dArray[i] * dArray3[j];
                iVec42.w += d3 * dArray[i] * dArray3[j];
            }
        }
        iVec4.x *= iVec42.w;
        iVec4.y *= iVec42.w;
        iVec4.z *= iVec42.w;
        iVec42.x *= iVec4.w;
        iVec42.y *= iVec4.w;
        iVec42.z *= iVec4.w;
        iVec4.w *= iVec4.w;
        iVec.x = (iVec42.x - iVec4.x) / iVec4.w;
        iVec.y = (iVec42.y - iVec4.y) / iVec4.w;
        iVec.z = (iVec42.z - iVec4.z) / iVec4.w;
    }

    public IVec nrml(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.nrml(iVec2.x, iVec2.y);
    }

    public IVec nrml(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.nrml(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec nrml(double d, double d2) {
        IVec iVec = new IVec();
        this.nrml(d, d2, iVec);
        return iVec;
    }

    public void nrml(double d, double d2, IVec iVec) {
        IVec iVec2 = new IVec();
        this.utan(d, d2, iVec);
        this.vtan(d, d2, iVec2);
        if (iVec.len() > 0.0 && iVec2.len() > 0.0) {
            iVec.icross(iVec2);
        } else if (iVec.len() > 0.0) {
            if (d2 > 0.5) {
                this.utan(d, 0.0, iVec2);
                iVec.icross(iVec2).neg();
            } else {
                this.utan(d, 1.0, iVec2);
                iVec.icross(iVec2);
            }
        } else if (iVec2.len() > 0.0) {
            if (d > 0.5) {
                this.vtan(0.0, d2, iVec);
                iVec.icross(iVec2);
            } else {
                this.vtan(1.0, d2, iVec);
                iVec.icross(iVec2).neg();
            }
        } else {
            IOut.debug(10, "normal is zero");
        }
    }

    public IVec normal(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.nrml(iVec2.x, iVec2.y);
    }

    public IVec normal(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.nrml(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec normal(double d, double d2) {
        IVec iVec = new IVec();
        this.nrml(d, d2, iVec);
        return iVec;
    }

    public void normal(double d, double d2, IVec iVec) {
        this.nrml(d, d2, iVec);
    }

    public IVec cp(int n, int n2) {
        return this.controlPoints[n][n2].get();
    }

    public IVecI cp(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.controlPoints[iIntegerI.x()][iIntegerI2.x()];
    }

    public IVec corner(int n, int n2) {
        if (n != 0) {
            n = 1;
        }
        if (n2 != 0) {
            n2 = 1;
        }
        return this.pt(n, n2);
    }

    public IVec corner(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.corner(iIntegerI.x(), iIntegerI2.x());
    }

    public IVec cornerCP(int n, int n2) {
        if (n != 0) {
            n = this.ucpNum() - 1;
        }
        if (n2 != 0) {
            n2 = this.vcpNum() - 1;
        }
        return this.controlPoints[n][n2].get();
    }

    public IVecI cornerCP(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        int n = 0;
        int n2 = 0;
        if (iIntegerI.x() != 0) {
            n = this.ucpNum() - 1;
        }
        if (iIntegerI2.x() != 0) {
            n2 = this.vcpNum() - 1;
        }
        return this.controlPoints[n][n2];
    }

    public IVec ep(int n, int n2) {
        return this.pt(this.uknots[n + this.udegree], this.vknots[n2 + this.vdegree]);
    }

    public IVec ep(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.pt(this.uknots[iIntegerI.x() + this.udegree], this.vknots[iIntegerI2.x() + this.vdegree]);
    }

    public double uknot(int n) {
        return this.uknots[n];
    }

    public IDouble uknot(IIntegerI iIntegerI) {
        return new IDouble(this.uknots[iIntegerI.x()]);
    }

    public double vknot(int n) {
        return this.vknots[n];
    }

    public IDouble vknot(IIntegerI iIntegerI) {
        return new IDouble(this.vknots[iIntegerI.x()]);
    }

    public int uknotNum() {
        return this.uknots.length;
    }

    public int vknotNum() {
        return this.vknots.length;
    }

    public int uknotNum(ISwitchE iSwitchE) {
        return this.uknotNum();
    }

    public int vknotNum(ISwitchE iSwitchE) {
        return this.vknotNum();
    }

    public IInteger uknotNum(ISwitchR iSwitchR) {
        return new IInteger(this.uknotNum());
    }

    public IInteger vknotNum(ISwitchR iSwitchR) {
        return new IInteger(this.vknotNum());
    }

    public boolean isRational() {
        if (this.defaultWeights == null) {
            IOut.err("defaultWeights is null");
            return false;
        }
        for (int i = 0; i < this.defaultWeights.length; ++i) {
            for (int j = 0; j < this.defaultWeights[i].length; ++j) {
                if (this.defaultWeights[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRational(ISwitchE iSwitchE) {
        return this.isRational();
    }

    public IBool isRational(ISwitchR iSwitchR) {
        return new IBool(this.isRational());
    }

    public int udeg() {
        return this.udegree;
    }

    public int vdeg() {
        return this.vdegree;
    }

    public int udeg(ISwitchE iSwitchE) {
        return this.udeg();
    }

    public int vdeg(ISwitchE iSwitchE) {
        return this.vdeg();
    }

    public IInteger udeg(ISwitchR iSwitchR) {
        return new IInteger(this.udeg());
    }

    public IInteger vdeg(ISwitchR iSwitchR) {
        return new IInteger(this.vdeg());
    }

    public int unum() {
        return this.controlPoints.length;
    }

    public int vnum() {
        return this.controlPoints[0].length;
    }

    public int unum(ISwitchE iSwitchE) {
        return this.unum();
    }

    public int vnum(ISwitchE iSwitchE) {
        return this.vnum();
    }

    public IInteger unum(ISwitchR iSwitchR) {
        return new IInteger(this.unum());
    }

    public IInteger vnum(ISwitchR iSwitchR) {
        return new IInteger(this.vnum());
    }

    public int ucpNum() {
        return this.unum();
    }

    public int vcpNum() {
        return this.vnum();
    }

    public int ucpNum(ISwitchE iSwitchE) {
        return this.ucpNum();
    }

    public int vcpNum(ISwitchE iSwitchE) {
        return this.vcpNum();
    }

    public IInteger ucpNum(ISwitchR iSwitchR) {
        return new IInteger(this.ucpNum());
    }

    public IInteger vcpNum(ISwitchR iSwitchR) {
        return new IInteger(this.vcpNum());
    }

    public int uepNum() {
        return this.uknots.length - 2 * this.udegree;
    }

    public int vepNum() {
        return this.vknots.length - 2 * this.vdegree;
    }

    public int uepNum(ISwitchE iSwitchE) {
        return this.uepNum();
    }

    public int vepNum(ISwitchE iSwitchE) {
        return this.vepNum();
    }

    public IInteger uepNum(ISwitchR iSwitchR) {
        return new IInteger(this.uepNum());
    }

    public IInteger vepNum(ISwitchR iSwitchR) {
        return new IInteger(this.vepNum());
    }

    public double u(int n, double d) {
        if (d >= 0.0) {
            return this.uknots[n + this.udegree] + (this.uknots[n + this.udegree + 1] - this.uknots[n + this.udegree]) * d;
        }
        return this.uknots[n + this.udegree] + (this.uknots[n + this.udegree] - this.uknots[n + this.udegree - 1]) * d;
    }

    public IDouble u(IIntegerI iIntegerI, IDoubleI iDoubleI) {
        return new IDouble(this.u(iIntegerI.x(), iDoubleI.x()));
    }

    public double v(int n, double d) {
        if (d >= 0.0) {
            return this.vknots[n + this.vdegree] + (this.vknots[n + this.vdegree + 1] - this.vknots[n + this.vdegree]) * d;
        }
        return this.vknots[n + this.vdegree] + (this.vknots[n + this.vdegree] - this.vknots[n + this.vdegree - 1]) * d;
    }

    public IDouble v(IIntegerI iIntegerI, IDoubleI iDoubleI) {
        return new IDouble(this.v(iIntegerI.x(), iDoubleI.x()));
    }

    public double ustart() {
        return this.ustart;
    }

    public double uend() {
        return this.uend;
    }

    public double vstart() {
        return this.vstart;
    }

    public double vend() {
        return this.vend;
    }

    public double ustart(ISwitchE iSwitchE) {
        return this.ustart();
    }

    public double uend(ISwitchE iSwitchE) {
        return this.uend();
    }

    public double vstart(ISwitchE iSwitchE) {
        return this.vstart();
    }

    public double vend(ISwitchE iSwitchE) {
        return this.vend();
    }

    public IDouble ustart(ISwitchR iSwitchR) {
        return new IDouble(this.ustart());
    }

    public IDouble uend(ISwitchR iSwitchR) {
        return new IDouble(this.uend());
    }

    public IDouble vstart(ISwitchR iSwitchR) {
        return new IDouble(this.vstart());
    }

    public IDouble vend(ISwitchR iSwitchR) {
        return new IDouble(this.vend());
    }

    public ISurfaceGeo clearInnerTrim() {
        for (int i = 0; this.innerTrimLoop != null && i < this.innerTrimLoop.size(); ++i) {
            ArrayList<ITrimCurve> arrayList = this.innerTrimLoop.get(i);
            arrayList.clear();
        }
        this.innerTrimLoop.clear();
        return this;
    }

    public ISurfaceGeo clearOuterTrim() {
        for (int i = 0; this.outerTrimLoop != null && i < this.outerTrimLoop.size(); ++i) {
            ArrayList<ITrimCurve> arrayList = this.outerTrimLoop.get(i);
            arrayList.clear();
        }
        this.outerTrimLoop.clear();
        return this;
    }

    public ISurfaceGeo clearTrim() {
        this.clearInnerTrim();
        this.clearOuterTrim();
        return this;
    }

    public static boolean isTrimLoopInsideBoundary(ITrimCurveI[] iTrimCurveIArray, double d, double d2, double d3, double d4) {
        boolean bl = false;
        for (int i = 0; i < iTrimCurveIArray.length; ++i) {
            if (ISurfaceGeo.isTrimCurveCPInsideBoundary(iTrimCurveIArray[i], d, d2, d3, d4)) continue;
            bl = true;
        }
        if (!bl) {
            return true;
        }
        ITrimLoopGraphic iTrimLoopGraphic = new ITrimLoopGraphic(iTrimCurveIArray, true, IConfig.surfaceTrimEdgeResolution);
        IPolyline2D iPolyline2D = iTrimLoopGraphic.getPolyline2D();
        IVec2 iVec2 = iPolyline2D.getMinBoundary();
        IVec2 iVec22 = iPolyline2D.getMaxBoundary();
        if (iVec2.x < d || iVec2.y < d2 || iVec22.x > d3 || iVec22.y > d4) {
            IOut.err("trim curve is outside boundary : min = " + iVec2 + ", max = " + iVec22);
            return false;
        }
        return true;
    }

    public static boolean isTrimCurveInsideBoundary(ITrimCurveI iTrimCurveI, double d, double d2, double d3, double d4) {
        if (!ISurfaceGeo.isTrimCurveCPInsideBoundary(iTrimCurveI, d, d2, d3, d4)) {
            return false;
        }
        ITrimCurveGraphic iTrimCurveGraphic = new ITrimCurveGraphic(iTrimCurveI);
        iTrimCurveGraphic.setup2D(IConfig.surfaceTrimEdgeResolution);
        IPolyline2D iPolyline2D = iTrimCurveGraphic.polyline2;
        IVec2 iVec2 = iPolyline2D.getMinBoundary();
        IVec2 iVec22 = iPolyline2D.getMaxBoundary();
        if (iVec2.x < d || iVec2.y < d2 || iVec22.x > d3 || iVec22.y > d4) {
            IOut.err("trim curve is outside boundary : min = " + iVec2 + ", max = " + iVec22);
            return false;
        }
        return true;
    }

    public static boolean isTrimCurveCPInsideBoundary(ITrimCurveI iTrimCurveI, double d, double d2, double d3, double d4) {
        for (int i = 0; i < iTrimCurveI.num(); ++i) {
            if (!(iTrimCurveI.cp((int)i).get().x < d || iTrimCurveI.cp((int)i).get().x > d3 || iTrimCurveI.cp((int)i).get().y < d2) && !(iTrimCurveI.cp((int)i).get().y > d4)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTrimLoopClosed(ITrimCurveI[] iTrimCurveIArray) {
        return iTrimCurveIArray[0].start2d().eq(iTrimCurveIArray[iTrimCurveIArray.length - 1].end2d());
    }

    public boolean checkTrimLoop(ITrimCurve[] iTrimCurveArray) {
        if (iTrimCurveArray == null) {
            IOut.err("trim loop is null");
            return false;
        }
        if (iTrimCurveArray.length == 0) {
            IOut.err("trim loop curve number is zero");
            return false;
        }
        if (!ISurfaceGeo.isTrimLoopInsideBoundary(iTrimCurveArray, 0.0, 0.0, 1.0, 1.0)) {
            IOut.err("trim loop is outside boundary of surface");
            return false;
        }
        if (!ISurfaceGeo.isTrimLoopClosed(iTrimCurveArray)) {
            IOut.err("trim loop is not closed");
            return false;
        }
        return true;
    }

    public boolean checkTrimLoop(ITrimCurve iTrimCurve) {
        if (iTrimCurve == null) {
            IOut.err("trim loop is null");
            return false;
        }
        if (!ISurfaceGeo.isTrimLoopInsideBoundary(new ITrimCurve[]{iTrimCurve}, 0.0, 0.0, 1.0, 1.0)) {
            IOut.err("trim loop is outside boundary of surface");
            return false;
        }
        if (!iTrimCurve.isClosed()) {
            IOut.err("trim loop is not closed");
            return false;
        }
        return true;
    }

    public boolean checkTrim(ITrimCurve iTrimCurve) {
        if (iTrimCurve == null) {
            IOut.err("trim loop is null");
            return false;
        }
        if (!ISurfaceGeo.isTrimCurveInsideBoundary(iTrimCurve, 0.0, 0.0, 1.0, 1.0)) {
            IOut.err("trim loop is outside boundary of surface");
            return false;
        }
        return true;
    }

    public ISurfaceGeo addDefaultOuterTrimLoop() {
        if (this.hasOuterTrim()) {
            IOut.err("the surface already has outer trim");
            return this;
        }
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[]{new ITrimCurve(new IVec(0.0, 0.0, 0.0), new IVec(1.0, 0.0, 0.0)), new ITrimCurve(new IVec(1.0, 0.0, 0.0), new IVec(1.0, 1.0, 0.0)), new ITrimCurve(new IVec(1.0, 1.0, 0.0), new IVec(0.0, 1.0, 0.0)), new ITrimCurve(new IVec(0.0, 1.0, 0.0), new IVec(0.0, 0.0, 0.0))};
        this.addOuterTrimLoop(iTrimCurveArray);
        return this;
    }

    public ISurfaceGeo addInnerTrimLoop(ITrimCurveI[] iTrimCurveIArray) {
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[iTrimCurveIArray.length];
        for (int i = 0; i < iTrimCurveIArray.length; ++i) {
            iTrimCurveArray[i] = iTrimCurveIArray[i].get();
        }
        return this.addInnerTrimLoop(iTrimCurveArray);
    }

    public ISurfaceGeo addInnerTrimLoop(ITrimCurve[] iTrimCurveArray) {
        if (!this.checkTrimLoop(iTrimCurveArray)) {
            return this;
        }
        if (this.innerTrimLoop == null) {
            this.innerTrimLoop = new ArrayList();
        }
        ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
        for (int i = 0; iTrimCurveArray != null && i < iTrimCurveArray.length; ++i) {
            arrayList.add(iTrimCurveArray[i].surface(this));
        }
        this.innerTrimLoop.add(arrayList);
        this.closeInnerTrim();
        return this;
    }

    public ISurfaceGeo addInnerTrimLoop(ITrimCurveI iTrimCurveI) {
        return this.addInnerTrimLoop(iTrimCurveI.get());
    }

    public ISurfaceGeo addInnerTrimLoop(ITrimCurve iTrimCurve) {
        if (!this.checkTrimLoop(iTrimCurve)) {
            return this;
        }
        if (this.innerTrimLoop == null) {
            this.innerTrimLoop = new ArrayList();
        }
        ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
        if (!iTrimCurve.isClosed()) {
            IOut.err("trim loop is not closed");
        }
        arrayList.add(iTrimCurve.surface(this));
        this.innerTrimLoop.add(arrayList);
        this.closeInnerTrim();
        return this;
    }

    public ISurfaceGeo addInnerTrimLoop(ICurveI[] iCurveIArray) {
        return this.addInnerTrimLoop(iCurveIArray, true);
    }

    public ISurfaceGeo addInnerTrimLoop(ICurveI[] iCurveIArray, boolean bl) {
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no trim input");
            return this;
        }
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[iCurveIArray.length];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            iTrimCurveArray[i] = new ITrimCurve(iCurveIArray[i]).surface(this);
            if (!bl || !(iCurveIArray[i] instanceof IObject)) continue;
            ((IObject)((Object)iCurveIArray[i])).del();
        }
        return this.addInnerTrimLoop(iTrimCurveArray);
    }

    public ISurfaceGeo addInnerTrimLoop(ICurveI iCurveI) {
        return this.addInnerTrimLoop(iCurveI, true);
    }

    public ISurfaceGeo addInnerTrimLoop(ICurveI iCurveI, boolean bl) {
        if (iCurveI == null) {
            IOut.err("no trim input");
            return this;
        }
        ITrimCurve iTrimCurve = new ITrimCurve(iCurveI).surface(this);
        if (bl && iCurveI instanceof IObject) {
            ((IObject)((Object)iCurveI)).del();
        }
        return this.addInnerTrimLoop(iTrimCurve);
    }

    public ISurfaceGeo addInnerTrim(ITrimCurve iTrimCurve) {
        if (!this.checkTrim(iTrimCurve)) {
            return this;
        }
        if (this.innerTrimLoop == null) {
            this.innerTrimLoop = new ArrayList();
            this.innerTrimLoop.add(new ArrayList());
        } else if (this.innerTrimClosed) {
            this.innerTrimLoop.add(new ArrayList());
            this.innerTrimClosed = false;
        }
        this.innerTrimLoop.get(this.innerTrimLoop.size() - 1).add(iTrimCurve.surface(this));
        return this;
    }

    public ISurfaceGeo closeInnerTrim() {
        this.innerTrimClosed = true;
        return this;
    }

    public ISurfaceGeo addOuterTrimLoop(ITrimCurveI[] iTrimCurveIArray) {
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[iTrimCurveIArray.length];
        for (int i = 0; i < iTrimCurveIArray.length; ++i) {
            iTrimCurveArray[i] = iTrimCurveIArray[i].get();
        }
        return this.addOuterTrimLoop(iTrimCurveArray);
    }

    public ISurfaceGeo addOuterTrimLoop(ITrimCurve[] iTrimCurveArray) {
        if (!this.checkTrimLoop(iTrimCurveArray)) {
            return this;
        }
        if (this.outerTrimLoop == null) {
            this.outerTrimLoop = new ArrayList();
        }
        ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
        for (int i = 0; iTrimCurveArray != null && i < iTrimCurveArray.length; ++i) {
            arrayList.add(iTrimCurveArray[i].surface(this));
        }
        this.outerTrimLoop.add(arrayList);
        this.closeOuterTrim();
        return this;
    }

    public ISurfaceGeo addOuterTrimLoop(ITrimCurveI iTrimCurveI) {
        return this.addOuterTrimLoop(iTrimCurveI.get());
    }

    public ISurfaceGeo addOuterTrimLoop(ITrimCurve iTrimCurve) {
        if (!this.checkTrimLoop(iTrimCurve)) {
            return this;
        }
        if (this.outerTrimLoop == null) {
            this.outerTrimLoop = new ArrayList();
        }
        ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
        if (!iTrimCurve.isClosed()) {
            IOut.err("trim loop is not closed");
        }
        arrayList.add(iTrimCurve.surface(this));
        this.outerTrimLoop.add(arrayList);
        this.closeOuterTrim();
        return this;
    }

    public ISurfaceGeo addOuterTrimLoop(ICurveI[] iCurveIArray) {
        return this.addOuterTrimLoop(iCurveIArray, true);
    }

    public ISurfaceGeo addOuterTrimLoop(ICurveI[] iCurveIArray, boolean bl) {
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no trim input");
            return this;
        }
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[iCurveIArray.length];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            iTrimCurveArray[i] = new ITrimCurve(iCurveIArray[i]).surface(this);
            if (!bl || !(iCurveIArray[i] instanceof IObject)) continue;
            ((IObject)((Object)iCurveIArray[i])).del();
        }
        return this.addOuterTrimLoop(iTrimCurveArray);
    }

    public ISurfaceGeo addOuterTrimLoop(ICurveI iCurveI) {
        return this.addOuterTrimLoop(iCurveI, true);
    }

    public ISurfaceGeo addOuterTrimLoop(ICurveI iCurveI, boolean bl) {
        if (iCurveI == null) {
            IOut.err("no trim input");
            return this;
        }
        ITrimCurve iTrimCurve = new ITrimCurve(iCurveI).surface(this);
        if (bl && iCurveI instanceof IObject) {
            ((IObject)((Object)iCurveI)).del();
        }
        return this.addOuterTrimLoop(iTrimCurve);
    }

    public ISurfaceGeo addOuterTrim(ITrimCurve iTrimCurve) {
        if (!this.checkTrim(iTrimCurve)) {
            return this;
        }
        if (this.outerTrimLoop == null) {
            this.outerTrimLoop = new ArrayList();
            this.outerTrimLoop.add(new ArrayList());
        } else if (this.outerTrimClosed) {
            this.outerTrimLoop.add(new ArrayList());
            this.outerTrimClosed = false;
        }
        this.outerTrimLoop.get(this.outerTrimLoop.size() - 1).add(iTrimCurve.surface(this));
        return this;
    }

    public ISurfaceGeo closeOuterTrim() {
        this.outerTrimClosed = true;
        return this;
    }

    public boolean hasTrim() {
        return this.hasInnerTrim() || this.hasOuterTrim();
    }

    public boolean hasInnerTrim() {
        return this.innerTrimLoop != null && this.innerTrimLoop.size() > 0;
    }

    public boolean hasOuterTrim() {
        return this.outerTrimLoop != null && this.outerTrimLoop.size() > 0;
    }

    public boolean hasTrim(ISwitchE iSwitchE) {
        return this.hasTrim();
    }

    public boolean hasInnerTrim(ISwitchE iSwitchE) {
        return this.hasInnerTrim();
    }

    public boolean hasOuterTrim(ISwitchE iSwitchE) {
        return this.hasOuterTrim();
    }

    public IBool hasTrim(ISwitchR iSwitchR) {
        return new IBool(this.hasTrim());
    }

    public IBool hasInnerTrim(ISwitchR iSwitchR) {
        return new IBool(this.hasInnerTrim());
    }

    public IBool hasOuterTrim(ISwitchR iSwitchR) {
        return new IBool(this.hasOuterTrim());
    }

    public int innerTrimLoopNum() {
        if (this.innerTrimLoop == null) {
            return 0;
        }
        return this.innerTrimLoop.size();
    }

    public int outerTrimLoopNum() {
        if (this.outerTrimLoop == null) {
            return 0;
        }
        return this.outerTrimLoop.size();
    }

    public int innerTrimLoopNum(ISwitchE iSwitchE) {
        return this.innerTrimLoopNum();
    }

    public int outerTrimLoopNum(ISwitchE iSwitchE) {
        return this.outerTrimLoopNum();
    }

    public IInteger innerTrimLoopNum(ISwitchR iSwitchR) {
        return new IInteger(this.innerTrimLoopNum());
    }

    public IInteger outerTrimLoopNum(ISwitchR iSwitchR) {
        return new IInteger(this.outerTrimLoopNum());
    }

    public int innerTrimNum(int n) {
        if (this.innerTrimLoop == null) {
            return 0;
        }
        return this.innerTrimLoop.get(n).size();
    }

    public IInteger innerTrimNum(IIntegerI iIntegerI) {
        return new IInteger(this.innerTrimNum(iIntegerI.x()));
    }

    public int outerTrimNum(int n) {
        if (this.outerTrimLoop == null) {
            return 0;
        }
        return this.outerTrimLoop.get(n).size();
    }

    public IInteger outerTrimNum(IIntegerI iIntegerI) {
        return new IInteger(this.outerTrimNum(iIntegerI.x()));
    }

    public ITrimCurveI[] innerTrimLoop(int n) {
        return this.innerTrimLoop.get(n).toArray(new ITrimCurve[this.innerTrimLoop.get(n).size()]);
    }

    public ITrimCurveI[] innerTrimLoop(IIntegerI iIntegerI) {
        return this.innerTrimLoop(iIntegerI.x());
    }

    public ITrimCurveI[] outerTrimLoop(int n) {
        return this.outerTrimLoop.get(n).toArray(new ITrimCurve[this.outerTrimLoop.get(n).size()]);
    }

    public ITrimCurveI[] outerTrimLoop(IIntegerI iIntegerI) {
        return this.outerTrimLoop(iIntegerI.x());
    }

    public ITrimCurveI innerTrim(int n, int n2) {
        return this.innerTrimLoop.get(n).get(n2);
    }

    public ITrimCurveI innerTrim(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.innerTrim(iIntegerI.x(), iIntegerI2.x());
    }

    public ITrimCurveI outerTrim(int n, int n2) {
        return this.outerTrimLoop.get(n).get(n2);
    }

    public ITrimCurveI outerTrim(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.outerTrim(iIntegerI.x(), iIntegerI2.x());
    }

    public boolean hasDefaultTrim() {
        if (this.outerTrimLoopNum() != 1) {
            return false;
        }
        IVec[] iVecArray = new IVec[4];
        if (this.outerTrimLoop.get(0).size() == 4) {
            for (int i = 0; i < this.outerTrimLoop.get(0).size(); ++i) {
                if (this.outerTrimLoop.get(0).get(i).deg() != 1 || this.outerTrimLoop.get(0).get(i).num() != 2) {
                    return false;
                }
                if (!this.outerTrimLoop.get(0).get(i).cp(1).get().eq(this.outerTrimLoop.get(0).get((i + 1) % 4).cp(0))) {
                    return false;
                }
                iVecArray[i] = this.outerTrimLoop.get(0).get(i).cp(0).get();
            }
        } else if (this.outerTrimLoop.get(0).size() == 1) {
            if (this.outerTrimLoop.get(0).get(0).deg() != 1 || this.outerTrimLoop.get(0).get(0).num() != 5) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                iVecArray[i] = this.outerTrimLoop.get(0).get(0).cp(i).get();
            }
        } else {
            return false;
        }
        return IVec.isArrayEqual(iVecArray, new IVec[]{new IVec(0.0, 0.0, 0.0), new IVec(1.0, 0.0, 0.0), new IVec(1.0, 1.0, 0.0), new IVec(0.0, 1.0, 0.0)}, true, true, 0.0);
    }

    public boolean hasDefaultTrim(ISwitchE iSwitchE) {
        return this.hasDefaultTrim();
    }

    public IBool hasDefaultTrim(ISwitchR iSwitchR) {
        return new IBool(this.hasDefaultTrim());
    }

    public boolean isFlat() {
        IVec iVec = this.corner(0, 0);
        IVec iVec2 = iVec.get().getNormal(this.corner(1, 0), this.corner(0, 1));
        if (!this.corner(1, 1).get().isOnPlane(iVec2, iVec)) {
            return false;
        }
        for (int i = 1; i < this.ucpNum() - 1; ++i) {
            for (int j = 1; j < this.vcpNum() - 1; ++j) {
                if (this.cp(i, j).get().isOnPlane(iVec2, iVec)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isFlat(ISwitchE iSwitchE) {
        return this.isFlat();
    }

    public IBool isFlat(ISwitchR iSwitchR) {
        return new IBool(this.isFlat());
    }
}

