/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IGraphicObject;
import igeo.core.ILayer;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IServerI;
import igeo.geo.IBool;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.IMatrix3I;
import igeo.geo.IMatrix4I;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.geo.IVec4;
import igeo.geo.IVecI;
import igeo.gui.IGraphicMode;
import igeo.gui.IPointGraphic;
import java.awt.Color;

public class IPoint
extends IObject
implements IVecI {
    public IVec pos;

    public IPoint() {
        this.pos = new IVec();
        this.initPoint(null);
    }

    public IPoint(IVec iVec) {
        this.pos = iVec;
        this.initPoint(null);
    }

    public IPoint(IVecI iVecI) {
        this.pos = iVecI.get();
        this.initPoint(null);
    }

    public IPoint(double d, double d2, double d3) {
        this.pos = new IVec(d, d2, d3);
        this.initPoint(null);
    }

    public IPoint(IServerI iServerI) {
        super(iServerI);
        this.pos = new IVec(0.0, 0.0, 0.0);
        this.initPoint(iServerI);
    }

    public IPoint(IServerI iServerI, IVec iVec) {
        super(iServerI);
        this.pos = iVec;
        this.initPoint(iServerI);
    }

    public IPoint(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        this.pos = iVecI.get();
        this.initPoint(iServerI);
    }

    public IPoint(IServerI iServerI, double d, double d2, double d3) {
        super(iServerI);
        this.pos = new IVec(d, d2, d3);
        this.initPoint(iServerI);
    }

    public IPoint(IPoint iPoint) {
        super(iPoint);
        this.pos = iPoint.pos.dup();
        this.initPoint(iPoint.server);
        this.setColor(iPoint.getColor());
    }

    public IPoint(IServerI iServerI, IPoint iPoint) {
        super(iServerI, iPoint);
        this.pos = iPoint.pos.dup();
        this.initPoint(iServerI);
        this.setColor(iPoint.getColor());
    }

    protected void initPoint(IServerI iServerI) {
        this.parameter = this.pos;
        if (this.graphics == null) {
            this.initGraphic(iServerI);
        }
    }

    public IGraphicObject createGraphic(IGraphicMode iGraphicMode) {
        return new IPointGraphic(this);
    }

    public double x() {
        return this.pos.x();
    }

    public double y() {
        return this.pos.y();
    }

    public double z() {
        return this.pos.z();
    }

    public IVec get() {
        return this.pos.get();
    }

    public IPoint dup() {
        return new IPoint(this);
    }

    public IVec2 to2d() {
        return this.pos.to2d();
    }

    public IVec4 to4d() {
        return this.pos.to4d();
    }

    public IVec4 to4d(double d) {
        return this.pos.to4d(d);
    }

    public IVec4 to4d(IDoubleI iDoubleI) {
        return this.pos.to4d(iDoubleI);
    }

    public IDouble getX() {
        return this.pos.getX();
    }

    public IDouble getY() {
        return this.pos.getY();
    }

    public IDouble getZ() {
        return this.pos.getZ();
    }

    public IPoint set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    public IPoint set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    public IPoint set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IPoint add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    public IPoint add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IPoint add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    public IPoint sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    public IPoint sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IPoint sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    public IPoint mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    public IPoint mul(double d) {
        this.pos.mul(d);
        return this;
    }

    public IPoint div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    public IPoint div(double d) {
        this.pos.div(d);
        return this;
    }

    public IPoint neg() {
        this.pos.neg();
        return this;
    }

    public IPoint rev() {
        return this.neg();
    }

    public IPoint add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    public IPoint add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    public double dot(IVecI iVecI) {
        return this.pos.dot(iVecI);
    }

    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dot(iSwitchE, iVecI);
    }

    public IDouble dot(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dot(iSwitchR, iVecI);
    }

    public IVec cross(IVecI iVecI) {
        return this.pos.cross(iVecI);
    }

    public double len() {
        return this.pos.len();
    }

    public double len(ISwitchE iSwitchE) {
        return this.pos.len(iSwitchE);
    }

    public IDouble len(ISwitchR iSwitchR) {
        return this.pos.len(iSwitchR);
    }

    public double len2() {
        return this.pos.len2();
    }

    public double len2(ISwitchE iSwitchE) {
        return this.pos.len2(iSwitchE);
    }

    public IDouble len2(ISwitchR iSwitchR) {
        return this.pos.len2(iSwitchR);
    }

    public IPoint len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    public IPoint len(double d) {
        this.pos.len(d);
        return this;
    }

    public IPoint unit() {
        this.pos.unit();
        return this;
    }

    public double dist(IVecI iVecI) {
        return this.pos.dist(iVecI);
    }

    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist(iSwitchE, iVecI);
    }

    public IDouble dist(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist(iSwitchR, iVecI);
    }

    public double dist2(IVecI iVecI) {
        return this.pos.dist2(iVecI);
    }

    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist2(iSwitchE, iVecI);
    }

    public IDouble dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist2(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI) {
        return this.pos.eq(iVecI);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eq(iSwitchE, iVecI);
    }

    public IBool eq(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eq(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI, double d) {
        return this.pos.eq(iVecI, d);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eq(iSwitchE, iVecI, d);
    }

    public IBool eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eq(iSwitchR, iVecI, iDoubleI);
    }

    public boolean eqX(IVecI iVecI) {
        return this.pos.eqX(iVecI);
    }

    public boolean eqY(IVecI iVecI) {
        return this.pos.eqY(iVecI);
    }

    public boolean eqZ(IVecI iVecI) {
        return this.pos.eqZ(iVecI);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqX(iSwitchE, iVecI);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqY(iSwitchE, iVecI);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqZ(iSwitchE, iVecI);
    }

    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqX(iSwitchR, iVecI);
    }

    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqY(iSwitchR, iVecI);
    }

    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqZ(iSwitchR, iVecI);
    }

    public boolean eqX(IVecI iVecI, double d) {
        return this.pos.eqX(iVecI, d);
    }

    public boolean eqY(IVecI iVecI, double d) {
        return this.pos.eqY(iVecI, d);
    }

    public boolean eqZ(IVecI iVecI, double d) {
        return this.pos.eqZ(iVecI, d);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqX(iSwitchE, iVecI, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqY(iSwitchE, iVecI, d);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqZ(iSwitchE, iVecI, d);
    }

    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqX(iSwitchR, iVecI, iDoubleI);
    }

    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqY(iSwitchR, iVecI, iDoubleI);
    }

    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqZ(iSwitchR, iVecI, iDoubleI);
    }

    public double angle(IVecI iVecI) {
        return this.pos.angle(iVecI);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.angle(iSwitchE, iVecI);
    }

    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.angle(iSwitchR, iVecI);
    }

    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iVecI, iVecI2);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchE, iVecI, iVecI2);
    }

    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchR, iVecI, iVecI2);
    }

    public IPoint rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    public IPoint rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    public IPoint rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    public IPoint rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IPoint rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    public IPoint rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IPoint scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    public IPoint scale(double d) {
        this.pos.scale(d);
        return this;
    }

    public IPoint scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    public IPoint scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    public IPoint ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    public IPoint ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    public IPoint mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    public IPoint mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    public IPoint transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    public IPoint transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    public IPoint transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IPoint transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    public IPoint diff(IVecI iVecI) {
        return this.dup().sub(iVecI);
    }

    public IPoint mid(IVecI iVecI) {
        return this.dup().add(iVecI).div(2.0);
    }

    public IPoint sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IPoint sum(IVecI ... iVecIArray) {
        IPoint iPoint = this.dup();
        for (IVecI iVecI : iVecIArray) {
            iPoint.add(iVecI);
        }
        return iPoint;
    }

    public IPoint bisect(IVecI iVecI) {
        return this.dup().unit().add(iVecI.dup().unit());
    }

    public IPoint sum(IVecI iVecI, double d, double d2) {
        return this.dup().mul(d).add(iVecI, d2);
    }

    public IPoint sum(IVecI iVecI, double d) {
        return this.dup().mul(1.0 - d).add(iVecI, d);
    }

    public IPoint sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.dup().mul(iDoubleI).add(iVecI, iDoubleI2);
    }

    public IPoint sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.dup().mul(new IDouble(1.0).sub(iDoubleI)).add(iVecI, iDoubleI);
    }

    public String toString() {
        return this.pos.toString();
    }

    public IPoint setSize(double d) {
        return this.size(d);
    }

    public IPoint size(double d) {
        for (int i = 0; this.graphics != null && i < this.graphics.size(); ++i) {
            if (!(this.graphics.get(i) instanceof IPointGraphic)) continue;
            ((IPointGraphic)this.graphics.get(i)).size(d);
        }
        return this;
    }

    public double getSize() {
        return this.size();
    }

    public double size() {
        if (this.graphics == null) {
            IOut.err("no graphics is set");
            return -1.0;
        }
        for (int i = 0; this.graphics != null && i < this.graphics.size(); ++i) {
            if (!(this.graphics.get(i) instanceof IPointGraphic)) continue;
            return ((IPointGraphic)this.graphics.get(i)).size();
        }
        return -1.0;
    }

    public IPoint name(String string) {
        super.name(string);
        return this;
    }

    public IPoint layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    public IPoint hide() {
        super.hide();
        return this;
    }

    public IPoint show() {
        super.show();
        return this;
    }

    public IPoint clr(Color color) {
        super.clr(color);
        return this;
    }

    public IPoint clr(int n) {
        super.clr(n);
        return this;
    }

    public IPoint clr(float f) {
        super.clr(f);
        return this;
    }

    public IPoint clr(double d) {
        super.clr(d);
        return this;
    }

    public IPoint clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    public IPoint clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    public IPoint clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    public IPoint clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    public IPoint clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    public IPoint clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    public IPoint clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    public IPoint clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    public IPoint clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    public IPoint hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    public IPoint hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    public IPoint hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    public IPoint hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    public IPoint setColor(Color color) {
        super.setColor(color);
        return this;
    }

    public IPoint setColor(int n) {
        super.setColor(n);
        return this;
    }

    public IPoint setColor(float f) {
        super.setColor(f);
        return this;
    }

    public IPoint setColor(double d) {
        super.setColor(d);
        return this;
    }

    public IPoint setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    public IPoint setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    public IPoint setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    public IPoint setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    public IPoint setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    public IPoint setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    public IPoint setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    public IPoint setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    public IPoint setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    public IPoint setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    public IPoint setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    public IPoint setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    public IPoint setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }
}

