/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IParameterObject;
import igeo.core.IServerI;
import igeo.geo.IVecI;

public class INurbsGeo
extends IParameterObject {
    INurbsGeo() {
    }

    INurbsGeo(IServerI iServerI) {
        if (iServerI != null) {
            this.createObject(iServerI);
        }
    }

    public static void normalizeKnots(double[] dArray, double d, double d2) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray[n2] = dArray[n2] - d;
            int n3 = n++;
            dArray[n3] = dArray[n3] / (d2 - d);
        }
    }

    public static double[] createKnots(int n, int n2, boolean bl) {
        if (bl) {
            return INurbsGeo.createClosedKnots(n, n2);
        }
        return INurbsGeo.createKnots(n, n2);
    }

    public static double[] createKnots(int n, int n2) {
        int n3;
        double[] dArray = new double[n + n2 + 1];
        for (n3 = 0; n3 <= n; ++n3) {
            dArray[n3] = 0.0;
        }
        int n4 = 1;
        while (n3 < n2) {
            dArray[n3] = (double)n4 / (double)(n2 - n);
            ++n3;
            ++n4;
        }
        while (n3 <= n + n2) {
            dArray[n3] = 1.0;
            ++n3;
        }
        return dArray;
    }

    public static double[] createClosedKnots(int n, int n2) {
        double[] dArray = new double[n + n2 + 1];
        int n3 = 0;
        int n4 = -n;
        while (n3 <= n + n2) {
            dArray[n3] = (double)n4 / (double)(n2 - n);
            ++n3;
            ++n4;
        }
        return dArray;
    }

    public static IVecI[] createClosedControlPoints(IVecI[] iVecIArray, int n) {
        int n2 = (n - 1) / 2;
        int n3 = n / 2 + 1;
        int n4 = iVecIArray.length;
        if (iVecIArray[0] == iVecIArray[iVecIArray.length - 1] || iVecIArray[0].eq(iVecIArray[iVecIArray.length - 1])) {
            if (n == 1) {
                return iVecIArray;
            }
            --n4;
        }
        IVecI[] iVecIArray2 = new IVecI[n4 + n];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            iVecIArray2[i] = i < n2 ? iVecIArray[(i - n2 + n4) % n4] : (i < iVecIArray2.length - n3 ? iVecIArray[i - n2] : iVecIArray[(i - (iVecIArray2.length - n3)) % n4]);
        }
        return iVecIArray2;
    }
}

