/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.core.IConfig;
import igeo.core.IGraphicObject;
import igeo.geo.ICurve;
import igeo.geo.ICurveI;
import igeo.geo.ICurveR;
import igeo.geo.IVec;
import igeo.gui.IGLLineStrip;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.ISurfaceGraphicGL;
import javax.media.opengl.GL;

public class ICurveGraphicGL
extends IGraphicObject {
    public static float weight = 1.0f;
    public ICurveI curve;
    public IGLLineStrip polyline;

    public ICurveGraphicGL(ICurve iCurve) {
        super(iCurve);
    }

    public ICurveGraphicGL(ICurveR iCurveR) {
        super(iCurveR);
    }

    public void initCurve() {
        if (this.parent instanceof ICurve) {
            this.curve = ((ICurve)this.parent).curve;
        } else if (this.parent instanceof ICurveR) {
            this.curve = ((ICurveR)this.parent).curve;
        }
        IVec[] iVecArray = null;
        if (this.curve.deg() == 1) {
            int n = this.curve.num();
            iVecArray = new IVec[n];
            for (int i = 0; i < n; ++i) {
                iVecArray[i] = this.curve.cp(i).get();
            }
        } else {
            int n = IConfig.curveGraphicResolution;
            int n2 = this.curve.epNum();
            int n3 = (n2 - 1) * n + 1;
            iVecArray = new IVec[n3];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (i >= n2 - 1 && j != 0) continue;
                    iVecArray[i * n + j] = this.curve.pt(this.curve.u(i, (double)j / (double)n)).get();
                }
            }
        }
        this.polyline = new IGLLineStrip(iVecArray);
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGL();
    }

    public void draw(IGraphics iGraphics) {
        GL gL;
        if (this.curve == null) {
            this.initCurve();
        }
        if ((gL = iGraphics.getGL()) != null) {
            gL.glLineWidth(weight);
            float f = ISurfaceGraphicGL.defaultColorRed;
            float f2 = ISurfaceGraphicGL.defaultColorGreen;
            float f3 = ISurfaceGraphicGL.defaultColorBlue;
            float f4 = ISurfaceGraphicGL.defaultColorAlpha;
            if (this.color != null) {
                f = (float)this.color.getRed() / 255.0f;
                f2 = (float)this.color.getGreen() / 255.0f;
                f3 = (float)this.color.getBlue() / 255.0f;
                f4 = (float)this.color.getAlpha() / 255.0f;
            }
            if (iGraphics.view().mode().isTransparent() && iGraphics.view().mode().isTransparentWireframe()) {
                f4 = (float)transparentModeAlpha;
            }
            if (iGraphics.view().mode().isLight() && iGraphics.view().mode().isLightWireframe()) {
                float[] fArray = new float[]{f, f2, f3, f4};
                gL.glMaterialfv(1032, 4608, fArray, 0);
                gL.glMaterialfv(1032, 4609, fArray, 0);
                gL.glMaterialf(1032, 5633, ISurfaceGraphicGL.defaultShininess);
                gL.glColor4f(f, f2, f3, 0.0f);
            } else {
                gL.glColor4f(f, f2, f3, f4);
            }
            if (iGraphics.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
                gL.glDisable(2896);
            }
            gL.glColor4f(f, f2, f3, f4);
            this.polyline.draw(gL);
            if (iGraphics.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
                gL.glEnable(2896);
            }
        }
    }
}

