/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IOut;
import igeo.geo.ICurve;
import igeo.geo.ICurveGeo;
import igeo.geo.ICurveI;
import igeo.geo.IDoubleI;
import igeo.geo.ISurfaceI;
import igeo.geo.ITrimCurveI;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.geo.IVec2I;
import igeo.geo.IVec4;
import igeo.geo.IVec4I;
import igeo.geo.IVecI;

public class ITrimCurve
extends ICurveGeo
implements ITrimCurveI {
    public ISurfaceI surface = null;

    public ITrimCurve() {
    }

    public ITrimCurve(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        super(iVecIArray, n, dArray, d, d2);
    }

    public ITrimCurve(IVecI[] iVecIArray, int n, double[] dArray) {
        super(iVecIArray, n, dArray);
    }

    public ITrimCurve(IVecI[] iVecIArray, int n) {
        super(iVecIArray, n);
    }

    public ITrimCurve(IVecI[] iVecIArray) {
        super(iVecIArray);
    }

    public ITrimCurve(IVecI[] iVecIArray, int n, boolean bl) {
        super(iVecIArray, n, bl);
    }

    public ITrimCurve(IVecI[] iVecIArray, boolean bl) {
        super(iVecIArray, bl);
    }

    public ITrimCurve(IVecI iVecI, IVecI iVecI2) {
        super(iVecI, iVecI2);
    }

    public ITrimCurve(double d, double d2, double d3, double d4) {
        super(d, d2, 0.0, d3, d4, 0.0);
    }

    public ITrimCurve(double[][] dArray) {
        super(dArray);
    }

    public ITrimCurve(double[][] dArray, int n) {
        super(dArray, n);
    }

    public ITrimCurve(double[][] dArray, boolean bl) {
        super(dArray, bl);
    }

    public ITrimCurve(double[][] dArray, int n, boolean bl) {
        super(dArray, n, bl);
    }

    public ITrimCurve(ICurveGeo iCurveGeo) {
        super(iCurveGeo);
    }

    public ITrimCurve(ICurve iCurve) {
        this(iCurve.curve);
    }

    public ITrimCurve(ICurveI iCurveI) {
        this(iCurveI.get());
    }

    public ITrimCurve(ITrimCurve iTrimCurve) {
        super(iTrimCurve);
        this.surface = iTrimCurve.surface;
    }

    public ITrimCurve surface(ISurfaceI iSurfaceI) {
        if (this.surface != null && this.surface != iSurfaceI) {
            IOut.err("surface is already set. overwritten.");
        }
        this.surface = iSurfaceI;
        return this;
    }

    public ISurfaceI surface() {
        return this.surface;
    }

    public ITrimCurve dup() {
        ITrimCurve iTrimCurve = new ITrimCurve(this);
        iTrimCurve.surface = null;
        return iTrimCurve;
    }

    public ITrimCurve get() {
        return this;
    }

    public ICurveGeo get3d() {
        Object object;
        int n;
        if (this.surface == null) {
            IOut.err("surface is not set");
            return null;
        }
        IVecI[] iVecIArray = new IVec[this.num()];
        for (n = 0; n < iVecIArray.length; ++n) {
            IVec iVec;
            object = this.cp(n);
            if (this.defaultWeights[n]) {
                iVec = object.get();
                iVecIArray[n] = this.surface.pt(iVec.x, iVec.y).get();
                continue;
            }
            iVec = object.get();
            IVec4 iVec4 = this.surface.pt(iVec.x, iVec.y).to4d().get();
            iVec4.w = object instanceof IVec4I ? ((IVec4I)object).w() : 1.0;
            iVecIArray[n] = iVec4;
        }
        n = this.deg();
        object = new double[this.knotNum()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = this.knot(i);
        }
        double d = this.ustart();
        double d2 = this.uend();
        return new ICurveGeo(iVecIArray, n, (double[])object, d, d2);
    }

    public void normalizeControlPoints() {
        this.normalizeControlPoints(this.surface);
    }

    public void normalizeControlPoints(ISurfaceI iSurfaceI) {
        double d = iSurfaceI.ustart();
        double d2 = iSurfaceI.uend();
        double d3 = iSurfaceI.vstart();
        double d4 = iSurfaceI.vend();
        if (d != 0.0 || d2 != 1.0 || d3 != 0.0 || d4 != 1.0) {
            for (IVecI iVecI : this.controlPoints) {
                iVecI.set((iVecI.x() - d) / (d2 - d), (iVecI.y() - d3) / (d4 - d3), iVecI.z());
            }
        }
    }

    public void pt(double d, IVec iVec) {
        IVec iVec2 = new IVec();
        super.pt(d, iVec2);
        iVec.set(this.surface.pt(iVec2.x, iVec2.y));
    }

    public void pt2d(double d, IVec2 iVec2) {
        IVec iVec = new IVec();
        super.pt(d, iVec);
        iVec2.set(iVec.x, iVec.y);
    }

    public IVec2I pt2d(double d) {
        IVec2 iVec2 = new IVec2();
        this.pt2d(d, iVec2);
        return iVec2;
    }

    public IVec2I pt2d(IDoubleI iDoubleI) {
        IVec2 iVec2 = new IVec2();
        this.pt2d(iDoubleI.x(), iVec2);
        return iVec2;
    }

    public IVec2 start2d() {
        IVec iVec = new IVec();
        super.pt(0.0, iVec);
        return new IVec2(iVec);
    }

    public IVec2 end2d() {
        IVec iVec = new IVec();
        super.pt(1.0, iVec);
        return new IVec2(iVec);
    }

    public IVec2 startCP2d() {
        return new IVec2(this.cp(0));
    }

    public IVec2 endCP2d() {
        return new IVec2(this.cp(this.num() - 1));
    }

    public void tan(double d, IVec iVec) {
        IVec iVec2 = new IVec();
        super.pt(d, iVec2);
        IVec iVec3 = new IVec();
        super.tan(d, iVec3);
        IVec iVec4 = this.surface.utan(iVec2.x, iVec2.y).get();
        IVec iVec5 = this.surface.vtan(iVec2.x, iVec2.y).get();
        iVec4.mul(iVec3.x).add(iVec5.mul(iVec3.y));
        iVec.set(iVec4);
    }

    public boolean isClosed() {
        boolean bl = true;
        if (this.knots[0] != 0.0 || this.knots[this.knots.length - 1] != 1.0) {
            bl = false;
        }
        if (bl) {
            return this.cp(0).eq(this.cp(this.cpNum() - 1));
        }
        return this.pt2d(0.0).eq(this.pt2d(1.0));
    }

    public ITrimCurve rev() {
        super.rev();
        return this;
    }
}

