/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.IDynamicObject;
import igeo.core.IG;
import igeo.core.IGraphicObject;
import igeo.core.ILayer;
import igeo.core.IOut;
import igeo.core.IParameterObject;
import igeo.core.IServer;
import igeo.core.IServerI;
import igeo.gui.IGraphicMode;
import java.awt.Color;
import java.util.ArrayList;

public class IObject {
    public int id;
    public String name;
    public IServer server;
    public IParameterObject parameter;
    public ArrayList<IGraphicObject> graphics;
    public ArrayList<IDynamicObject> dynamics;
    public ILayer layer;

    public IObject() {
        this.initObject(null);
    }

    public IObject(IServerI iServerI) {
        this.initObject(iServerI);
    }

    public IObject(IObject iObject) {
        this.initObject(iObject.server);
    }

    public IObject(IServerI iServerI, IObject iObject) {
        this.initObject(iServerI);
    }

    public IObject dup() {
        return new IObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initObject(IServerI iServerI) {
        Object object;
        this.server = null;
        if (iServerI == null) {
            object = IG.current();
            if (object == null) {
                IOut.err("no IG is found. IObject is not stored in a server.");
                return;
            }
            this.server = ((IG)object).server();
        } else {
            this.server = iServerI.server();
        }
        object = IG.lock;
        synchronized (object) {
            this.server.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initGraphic(IServerI iServerI) {
        Object object;
        this.server = null;
        if (iServerI == null) {
            object = IG.current();
            if (object == null) {
                IOut.err("no IG is found. IObject is not stored in a server.");
                return;
            }
            this.server = ((IG)object).server();
        } else {
            this.server = iServerI.server();
        }
        if (this.server.isGraphicMode()) {
            object = IG.lock;
            synchronized (object) {
                this.server.graphicServer().add(this);
            }
        }
    }

    public void del() {
        if (this.server != null) {
            this.server.remove(this);
        } else if (IG.current() != null) {
            IG.current().server().remove(this);
        }
    }

    public void setParameter(IParameterObject iParameterObject) {
        if (this.parameter != null) {
            IOut.err("parameter is already set. overwrote.");
        }
        this.parameter = iParameterObject;
    }

    public IParameterObject getParameter() {
        return this.parameter;
    }

    public IGraphicObject getGraphic(int n) {
        if (this.graphics == null) {
            return null;
        }
        return this.graphics.get(n);
    }

    public IDynamicObject getDynamics(int n) {
        if (this.dynamics == null) {
            return null;
        }
        return this.dynamics.get(n);
    }

    public int graphicsNum() {
        if (this.graphics == null) {
            return 0;
        }
        return this.graphics.size();
    }

    public int dynamicsNum() {
        if (this.dynamics == null) {
            return 0;
        }
        return this.dynamics.size();
    }

    public void clearGraphics() {
        if (this.graphics != null) {
            this.graphics.clear();
        }
    }

    public void clearDynamics() {
        if (this.dynamics != null) {
            this.dynamics.clear();
        }
    }

    public IGraphicObject getGraphic(IGraphicMode iGraphicMode) {
        if (this.graphics == null) {
            this.graphics = new ArrayList();
        } else {
            for (IGraphicObject iGraphicObject : this.graphics) {
                if (!iGraphicObject.isDrawable(iGraphicMode)) continue;
                return iGraphicObject;
            }
        }
        IGraphicObject iGraphicObject = this.createGraphic(iGraphicMode);
        if (iGraphicObject != null) {
            this.graphics.add(iGraphicObject);
        }
        return iGraphicObject;
    }

    public IGraphicObject createGraphic(IGraphicMode iGraphicMode) {
        return null;
    }

    public void deleteGraphic() {
        if (this.server != null && this.server.graphicServer != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                this.server.graphicServer.remove(iGraphicObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraphic() {
        this.deleteGraphic();
        if (this.server != null && this.server.graphicServer != null) {
            Object object = IG.lock;
            synchronized (object) {
                this.server.graphicServer().add(this);
            }
        }
    }

    public String name() {
        return this.name;
    }

    public IObject name(String string) {
        this.name = string;
        return this;
    }

    public ILayer layer() {
        return this.layer;
    }

    public IObject layer(ILayer iLayer) {
        if (iLayer == null) {
            this.layer = null;
        } else if (this.layer != iLayer) {
            if (!iLayer.contains(this)) {
                iLayer.add(this);
            }
            this.layer = iLayer;
        }
        return this;
    }

    public boolean visible() {
        if (this.graphics == null) {
            return false;
        }
        for (IGraphicObject iGraphicObject : this.graphics) {
            if (!iGraphicObject.visible()) continue;
            return true;
        }
        return false;
    }

    public boolean isVisible() {
        return this.visible();
    }

    public IObject hide() {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.hide();
            }
        }
        return this;
    }

    public IObject show() {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.show();
            }
        }
        return this;
    }

    public Color clr() {
        if (this.graphics == null) {
            return null;
        }
        for (IGraphicObject iGraphicObject : this.graphics) {
            if (iGraphicObject.getColor() == null) continue;
            return iGraphicObject.getColor();
        }
        return null;
    }

    public IObject clr(Color color) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(color);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(int n) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(n);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(double d) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor((float)d);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(float f) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(f);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(int n, int n2) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(n, n2);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(double d, double d2) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor((float)d, (float)d2);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(float f, float f2) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(f, f2);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(int n, int n2, int n3) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(n, n2, n3);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(double d, double d2, double d3) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor((float)d, (float)d2, (float)d3);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(float f, float f2, float f3) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(f, f2, f3);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(int n, int n2, int n3, int n4) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(n, n2, n3, n4);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(double d, double d2, double d3, double d4) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor((float)d, (float)d2, (float)d3, (float)d4);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject clr(float f, float f2, float f3, float f4) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(f, f2, f3, f4);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject hsb(double d, double d2, double d3, double d4) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setHSBColor((float)d, (float)d2, (float)d3, (float)d4);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject hsb(float f, float f2, float f3, float f4) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setHSBColor(f, f2, f3, f4);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject hsb(double d, double d2, double d3) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setHSBColor((float)d, (float)d2, (float)d3);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public IObject hsb(float f, float f2, float f3) {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setHSBColor(f, f2, f3);
            }
        } else {
            IOut.err("no graphics created yet");
        }
        return this;
    }

    public Color getColor() {
        return this.clr();
    }

    public IObject setColor(Color color) {
        return this.clr(color);
    }

    public IObject setColor(int n) {
        return this.clr(n);
    }

    public IObject setColor(float f) {
        return this.clr(f);
    }

    public IObject setColor(double d) {
        return this.clr(d);
    }

    public IObject setColor(int n, int n2) {
        return this.clr(n, n2);
    }

    public IObject setColor(float f, float f2) {
        return this.clr(f, f2);
    }

    public IObject setColor(double d, double d2) {
        return this.clr(d, d2);
    }

    public IObject setColor(int n, int n2, int n3) {
        return this.clr(n, n2, n3);
    }

    public IObject setColor(float f, float f2, float f3) {
        return this.clr(f, f2, f3);
    }

    public IObject setColor(double d, double d2, double d3) {
        return this.clr(d, d2, d3);
    }

    public IObject setColor(int n, int n2, int n3, int n4) {
        return this.clr(n, n2, n3, n4);
    }

    public IObject setColor(float f, float f2, float f3, float f4) {
        return this.clr(f, f2, f3, f4);
    }

    public IObject setColor(double d, double d2, double d3, double d4) {
        return this.clr(d, d2, d3, d4);
    }

    public IObject setHSBColor(float f, float f2, float f3, float f4) {
        return this.hsb(f, f2, f3, f4);
    }

    public IObject setHSBColor(double d, double d2, double d3, double d4) {
        return this.hsb(d, d2, d3, d4);
    }

    public IObject setHSBColor(float f, float f2, float f3) {
        return this.hsb(f, f2, f3);
    }

    public IObject setHSBColor(double d, double d2, double d3) {
        return this.hsb(d, d2, d3);
    }
}

