/*
 * Decompiled with CFR 0.152.
 */
package igeo.util;

import igeo.geo.IVec;
import java.awt.Color;
import java.util.Random;

public class IRandom {
    static final long defaultSeed = 1L;
    protected static Random random = null;

    public static void init() {
        IRandom.init(1L);
    }

    public static void init(long l) {
        random = new Random(l);
    }

    public static void initByTime() {
        random = new Random(System.currentTimeMillis());
    }

    public static double get() {
        if (random == null) {
            IRandom.init();
        }
        return random.nextDouble();
    }

    public static double getDouble() {
        return IRandom.get();
    }

    public static double get(double d, double d2) {
        if (random == null) {
            IRandom.init();
        }
        return random.nextDouble() * (d2 - d) + d;
    }

    public static float getf() {
        if (random == null) {
            IRandom.init();
        }
        return random.nextFloat();
    }

    public static float getFloat() {
        return IRandom.getf();
    }

    public static int geti(int n, int n2) {
        int n3 = (int)IRandom.get(n, n2 + 1);
        if (n3 > n2) {
            n3 = n2;
        }
        return n3;
    }

    public static int getInt(int n, int n2) {
        return IRandom.geti(n, n2);
    }

    public static int getInteger(int n, int n2) {
        return IRandom.geti(n, n2);
    }

    public static IVec pt(IVec iVec, IVec iVec2) {
        return new IVec(IRandom.get(iVec.x, iVec2.x), IRandom.get(iVec.y, iVec2.y), IRandom.get(iVec.z, iVec2.z));
    }

    public static IVec point(IVec iVec, IVec iVec2) {
        return IRandom.pt(iVec, iVec2);
    }

    public static IVec getPoint(IVec iVec, IVec iVec2) {
        return IRandom.pt(iVec, iVec2);
    }

    public static IVec pt(double d, double d2, double d3, double d4, double d5, double d6) {
        return new IVec(IRandom.get(d, d4), IRandom.get(d2, d5), IRandom.get(d3, d6));
    }

    public static IVec point(double d, double d2, double d3, double d4, double d5, double d6) {
        return IRandom.pt(d, d2, d3, d4, d5, d6);
    }

    public static IVec getPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        return IRandom.pt(d, d2, d3, d4, d5, d6);
    }

    public static boolean getPercent(double d) {
        return IRandom.percent(d);
    }

    public static boolean percent(double d) {
        return IRandom.get() < d / 100.0;
    }

    public static Color getColor() {
        return IRandom.clr();
    }

    public static Color clr() {
        return new Color(IRandom.getInt(0, 255), IRandom.getInt(0, 255), IRandom.getInt(0, 255));
    }

    public static Color getColor(int n) {
        return IRandom.clr(n);
    }

    public static Color clr(int n) {
        return new Color(IRandom.getInt(0, 255), IRandom.getInt(0, 255), IRandom.getInt(0, 255), n);
    }

    public static Color getColor(float f) {
        return IRandom.clr(f);
    }

    public static Color clr(float f) {
        return new Color(IRandom.getFloat(), IRandom.getFloat(), IRandom.getFloat(), f);
    }

    public static Color getGrayColor() {
        return IRandom.gray();
    }

    public static Color getGray() {
        return IRandom.gray();
    }

    public static Color gray() {
        int n = IRandom.getInt(0, 255);
        return new Color(n, n, n);
    }

    public static Color getGrayColor(int n) {
        return IRandom.gray(n);
    }

    public static Color getGray(int n) {
        return IRandom.gray(n);
    }

    public static Color gray(int n) {
        int n2 = IRandom.getInt(0, 255);
        return new Color(n2, n2, n2, n);
    }

    public static Color getGrayColor(float f) {
        return IRandom.gray(f);
    }

    public static Color getGray(float f) {
        return IRandom.gray(f);
    }

    public static Color gray(float f) {
        float f2 = IRandom.getFloat();
        return new Color(f2, f2, f2, f);
    }
}

