/*
 * Decompiled with CFR 0.152.
 */
package igeo.util;

import igeo.geo.ICurveI;
import igeo.geo.ISurfaceI;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.gui.IImageLoader;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;

public class IMap {
    public static final int defaultDensityWidth = 100;
    public static final int defaultDensityHeight = 100;
    public static final double densityMinDelta = 1.0E-4;
    public DoubleMap uIntegration = null;
    public DoubleMap vIntegration = null;

    public double get(double d, double d2) {
        return 0.0;
    }

    public void initDensityMapU() {
        this.initDensityMapU(100, 100);
    }

    public void initDensityMapV() {
        this.initDensityMapV(100, 100);
    }

    public void initDensityMapU(int n, int n2) {
        int n3;
        double d;
        int n4;
        this.uIntegration = new DoubleMap(n + 1, n2);
        for (n4 = 0; n4 < n2; ++n4) {
            d = 0.0;
            this.uIntegration.set(0, n4, d);
            for (n3 = 0; n3 < n; ++n3) {
                this.uIntegration.set(n3 + 1, n4, d += this.get((double)n3 / (double)(n - 1), (double)n4 / (double)(n2 - 1)));
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            d = this.uIntegration.map[n][n4];
            for (n3 = 1; n3 <= n; ++n3) {
                if (d > 0.0) {
                    double[] dArray = this.uIntegration.map[n3];
                    int n5 = n4;
                    dArray[n5] = dArray[n5] / d;
                    continue;
                }
                double[] dArray = this.uIntegration.map[n3];
                int n6 = n4;
                dArray[n6] = dArray[n6] / ((double)n3 / (double)n);
            }
        }
    }

    public void initDensityMapV(int n, int n2) {
        int n3;
        double d;
        int n4;
        this.vIntegration = new DoubleMap(n, n2 + 1);
        for (n4 = 0; n4 < n; ++n4) {
            d = 0.0;
            this.vIntegration.set(n4, 0, d);
            for (n3 = 0; n3 < n2; ++n3) {
                this.vIntegration.set(n4, n3 + 1, d += this.get((double)n4 / (double)(n - 1), (double)n3 / (double)(n2 - 1)));
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            d = this.vIntegration.map[n4][n2];
            for (n3 = 1; n3 <= n2; ++n3) {
                if (d > 0.0) {
                    double[] dArray = this.vIntegration.map[n4];
                    int n5 = n3;
                    dArray[n5] = dArray[n5] / d;
                    continue;
                }
                double[] dArray = this.vIntegration.map[n4];
                int n6 = n3;
                dArray[n6] = dArray[n6] / ((double)n3 / (double)n2);
            }
        }
    }

    public void scaleDensityMapU(double d) {
        this.uIntegration.scale(d);
    }

    public void scaleDensityMapV(double d) {
        this.vIntegration.scale(d);
    }

    public void matchUDensityWithMap(IMap iMap, double d, double d2) {
        this.matchUDensityWithMap(iMap, d, d + 1.0E-4, d2);
    }

    public void matchUDensityWithMap(IMap iMap, double d, double d2, double d3) {
        double d4 = this.projectU(d, d3);
        double d5 = this.projectU(d2, d3);
        double d6 = iMap.projectU(d, d3);
        double d7 = iMap.projectU(d2, d3);
        this.scaleDensityMapU((d7 - d6) / (d5 - d4));
    }

    public void matchVDensityWithMap(IMap iMap, double d, double d2) {
        this.matchVDensityWithMap(iMap, d, d2, d2 + 1.0E-4);
    }

    public void matchVDensityWithMap(IMap iMap, double d, double d2, double d3) {
        double d4 = this.projectU(d, d2);
        double d5 = this.projectU(d, d3);
        double d6 = iMap.projectU(d, d2);
        double d7 = iMap.projectU(d, d3);
        this.scaleDensityMapV((d7 - d6) / (d5 - d4));
    }

    public BufferedImage createImage(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = this.get((double)i / (double)(n - 1), (double)j / (double)(n2 - 1));
                int n3 = (int)(d * 255.0);
                int n4 = n3 * 256 * 256 + n3 * 256 + n3;
                bufferedImage.setRGB(i, j, n4);
            }
        }
        return bufferedImage;
    }

    public double projectU(double d, double d2) {
        if (this.uIntegration == null) {
            this.initDensityMapU();
        }
        return this.uIntegration.get(d, d2);
    }

    public double projectV(double d, double d2) {
        if (this.vIntegration == null) {
            this.initDensityMapV();
        }
        return this.vIntegration.get(d, d2);
    }

    public IVec2 project(double d, double d2) {
        if (this.uIntegration == null) {
            this.initDensityMapU();
        }
        if (this.vIntegration == null) {
            this.initDensityMapV();
        }
        return new IVec2(this.uIntegration.get(d, d2), this.vIntegration.get(d, d2));
    }

    public void flipU() {
    }

    public void flipV() {
    }

    public static class ConstantMap
    extends IMap {
        public double value;

        public ConstantMap(double d) {
            this.value = d;
        }

        public double get(double d, double d2) {
            return this.value;
        }
    }

    public static class SubMap
    extends IMap {
        public IMap map;
        public double u1;
        public double u2;
        public double v1;
        public double v2;

        public SubMap(IMap iMap, double d, double d2, double d3, double d4) {
            this.map = iMap;
            this.u1 = d;
            this.u2 = d2;
            this.v1 = d3;
            this.v2 = d4;
        }

        public double get(double d, double d2) {
            return this.map.get((this.u2 - this.u1) * d + this.u1, (this.v2 - this.v1) * d2 + this.v1);
        }
    }

    public static class VFlippedMap
    extends IMap {
        public IMap map;

        public VFlippedMap(IMap iMap) {
            this.map = iMap;
        }

        public double get(double d, double d2) {
            return this.map.get(d, 1.0 - d2);
        }

        public void flipU() {
            this.map.flipU();
        }

        public void flipV() {
            this.map.flipV();
        }
    }

    public static class UFlippedMap
    extends IMap {
        public IMap map;

        public UFlippedMap(IMap iMap) {
            this.map = iMap;
        }

        public double get(double d, double d2) {
            return this.map.get(1.0 - d, d2);
        }

        public void flipU() {
            this.map.flipU();
        }

        public void flipV() {
            this.map.flipV();
        }
    }

    public static class ScaledMap
    extends IMap {
        public IMap map;
        public double scaleFactor;

        public ScaledMap(IMap iMap, double d) {
            this.map = iMap;
            this.scaleFactor = d;
        }

        public double get(double d, double d2) {
            return this.map.get(d, d2) * this.scaleFactor;
        }

        public void flipU() {
            this.map.flipU();
        }

        public void flipV() {
            this.map.flipV();
        }
    }

    public static class InvertMap
    extends IMap {
        public IMap map;

        public InvertMap(IMap iMap) {
            this.map = iMap;
        }

        public double get(double d, double d2) {
            return 1.0 - this.map.get(d, d2);
        }

        public void flipU() {
            this.map.flipU();
        }

        public void flipV() {
            this.map.flipV();
        }
    }

    public static class MinMap
    extends IMap {
        public IMap map1;
        public IMap map2;

        public MinMap(IMap iMap, IMap iMap2) {
            this.map1 = iMap;
            this.map2 = iMap2;
        }

        public double get(double d, double d2) {
            double d3;
            double d4 = this.map1.get(d, d2);
            if (d4 < (d3 = this.map2.get(d, d2))) {
                return d4;
            }
            return d3;
        }

        public void flipU() {
            this.map1.flipU();
            this.map2.flipU();
        }

        public void flipV() {
            this.map1.flipV();
            this.map2.flipV();
        }
    }

    public static class MaxMap
    extends IMap {
        public IMap map1;
        public IMap map2;

        public MaxMap(IMap iMap, IMap iMap2) {
            this.map1 = iMap;
            this.map2 = iMap2;
        }

        public double get(double d, double d2) {
            double d3;
            double d4 = this.map1.get(d, d2);
            if (d4 > (d3 = this.map2.get(d, d2))) {
                return d4;
            }
            return d3;
        }

        public void flipU() {
            this.map1.flipU();
            this.map2.flipU();
        }

        public void flipV() {
            this.map1.flipV();
            this.map2.flipV();
        }
    }

    public static class MultipliedMap
    extends IMap {
        public IMap map1;
        public IMap map2;

        public MultipliedMap(IMap iMap, IMap iMap2) {
            this.map1 = iMap;
            this.map2 = iMap2;
        }

        public double get(double d, double d2) {
            return this.map1.get(d, d2) * this.map2.get(d, d2);
        }

        public void flipU() {
            this.map1.flipU();
            this.map2.flipU();
        }

        public void flipV() {
            this.map1.flipV();
            this.map2.flipV();
        }
    }

    public static class SubtractedMap
    extends IMap {
        public IMap map1;
        public IMap map2;

        public SubtractedMap(IMap iMap, IMap iMap2) {
            this.map1 = iMap;
            this.map2 = iMap2;
        }

        public double get(double d, double d2) {
            double d3 = this.map1.get(d, d2) - this.map2.get(d, d2);
            if (d3 > 1.0) {
                return 1.0;
            }
            if (d3 < 0.0) {
                return 0.0;
            }
            return d3;
        }

        public void flipU() {
            this.map1.flipU();
            this.map2.flipU();
        }

        public void flipV() {
            this.map1.flipV();
            this.map2.flipV();
        }
    }

    public static class AddedMap
    extends IMap {
        public IMap map1;
        public IMap map2;

        public AddedMap(IMap iMap, IMap iMap2) {
            this.map1 = iMap;
            this.map2 = iMap2;
        }

        public double get(double d, double d2) {
            double d3 = this.map1.get(d, d2) + this.map2.get(d, d2);
            if (d3 > 1.0) {
                return 1.0;
            }
            if (d3 < 0.0) {
                return 0.0;
            }
            return d3;
        }

        public void flipU() {
            this.map1.flipU();
            this.map2.flipU();
        }

        public void flipV() {
            this.map1.flipV();
            this.map2.flipV();
        }
    }

    public static class VStripeShiftMap
    extends IMap {
        public ArrayList<Double> domains;
        public ArrayList<Double> shiftAmounts;
        public IMap origMap;

        public VStripeShiftMap(IMap iMap) {
            this.origMap = iMap;
            this.domains = new ArrayList();
            this.shiftAmounts = new ArrayList();
        }

        public VStripeShiftMap(IMap iMap, double d) {
            this.origMap = iMap;
            this.domains = new ArrayList();
            this.shiftAmounts = new ArrayList();
            this.addShift(0.0, d);
            this.addShift(1.0, d);
        }

        public void addShift(double d, double d2) {
            this.domains.add(d);
            this.shiftAmounts.add(d2);
        }

        public double get(double d, double d2) {
            double d3 = this.getShift(d);
            if (d2 + d3 < 0.0) {
                return this.origMap.get(d, 0.0);
            }
            if (d2 + d3 > 1.0) {
                return this.origMap.get(d, 1.0);
            }
            return this.origMap.get(d, d2 + d3);
        }

        public double getShift(double d) {
            for (int i = 0; i < this.domains.size() - 1; ++i) {
                if (i == 0 && d <= this.domains.get(i)) {
                    return 0.0;
                }
                if (d >= this.domains.get(i) && d < this.domains.get(i + 1)) {
                    return this.shiftAmounts.get(i);
                }
                if (i != this.domains.size() - 2 || !(d >= this.domains.get(i + 1))) continue;
                return this.shiftAmounts.get(i + 1);
            }
            return 0.0;
        }
    }

    public static class UStripeShiftMap
    extends IMap {
        public ArrayList<Double> domains;
        public ArrayList<Double> shiftAmounts;
        public IMap origMap;

        public UStripeShiftMap(IMap iMap) {
            this.origMap = iMap;
            this.domains = new ArrayList();
            this.shiftAmounts = new ArrayList();
        }

        public UStripeShiftMap(IMap iMap, double d) {
            this.origMap = iMap;
            this.domains = new ArrayList();
            this.shiftAmounts = new ArrayList();
            this.addShift(0.0, d);
            this.addShift(1.0, d);
        }

        public void addShift(double d, double d2) {
            this.domains.add(d);
            this.shiftAmounts.add(d2);
        }

        public double get(double d, double d2) {
            double d3 = this.getShift(d2);
            if (d + d3 < 0.0) {
                return this.origMap.get(0.0, d2);
            }
            if (d + d3 > 1.0) {
                return this.origMap.get(1.0, d2);
            }
            return this.origMap.get(d + d3, d2);
        }

        public double getShift(double d) {
            for (int i = 0; i < this.domains.size() - 1; ++i) {
                if (i == 0 && d <= this.domains.get(i)) {
                    return 0.0;
                }
                if (d >= this.domains.get(i) && d < this.domains.get(i + 1)) {
                    return this.shiftAmounts.get(i);
                }
                if (i != this.domains.size() - 2 || !(d >= this.domains.get(i + 1))) continue;
                return this.shiftAmounts.get(i + 1);
            }
            return 0.0;
        }
    }

    public static class SurfaceZDepthMap
    extends SurfaceDepthMap {
        public SurfaceZDepthMap(ISurfaceI iSurfaceI, double d, double d2) {
            super(iSurfaceI, new IVec(0.0, 0.0, 1.0), new IVec(0.0, 0.0, d), new IVec(0.0, 0.0, d2));
        }

        public SurfaceZDepthMap(ISurfaceI iSurfaceI) {
            super(iSurfaceI, new IVec(0.0, 0.0, 1.0), new IVec(0.0, 0.0, 0.0), new IVec(0.0, 0.0, 1.0));
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < 20; ++i) {
                for (int j = 0; j < 20; ++j) {
                    double d3 = this.surface.pt((double)i / 20.0, (double)j / 20.0).z();
                    if (i == 0 && j == 0) {
                        d = d2 = d3;
                        continue;
                    }
                    if (d3 < d) {
                        d = d3;
                    }
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                }
            }
            this.minDepthPt.set(0.0, 0.0, d);
            this.maxDepth = d2 - d;
        }
    }

    public static class SurfaceDepthMap
    extends IMap {
        public ISurfaceI surface;
        public IVec orig;
        public IVec uvec;
        public IVec vvec;
        public IVec minDepthPt = null;
        public IVec depthDir = null;
        public double maxDepth = 0.0;

        public SurfaceDepthMap(ISurfaceI iSurfaceI) {
            this.surface = iSurfaceI;
            this.initMap();
        }

        public SurfaceDepthMap(ISurfaceI iSurfaceI, IVec iVec) {
            this.surface = iSurfaceI;
            this.depthDir = iVec;
            this.initMap();
        }

        public SurfaceDepthMap(ISurfaceI iSurfaceI, IVec iVec, IVec iVec2, IVec iVec3) {
            this.surface = iSurfaceI;
            this.depthDir = iVec.dup().unit();
            this.minDepthPt = iVec2;
            this.maxDepth = iVec3.diff(iVec2).dot(this.depthDir);
        }

        public SurfaceDepthMap(ISurfaceI iSurfaceI, ICurveI iCurveI) {
            this.surface = iSurfaceI;
            this.minDepthPt = iCurveI.start().get();
            this.depthDir = iCurveI.end().get().diff(this.minDepthPt);
            this.maxDepth = this.depthDir.len();
            this.depthDir.unit();
            this.initMap();
        }

        public void initMap() {
            if (this.minDepthPt == null || this.depthDir == null) {
                this.orig = this.surface.corner(0, 0).get();
                this.uvec = this.surface.corner(1, 0).get().diff(this.orig);
                this.vvec = this.surface.corner(0, 1).get().diff(this.orig);
                this.minDepthPt = this.orig;
                if (this.depthDir == null) {
                    this.depthDir = this.uvec.cross(this.vvec).unit();
                }
                double d = 0.0;
                double d2 = 0.0;
                for (int i = 0; i < this.surface.unum(); ++i) {
                    for (int j = 0; j < this.surface.vnum(); ++j) {
                        double d3 = this.getDepth(this.surface.cp(i, j).get());
                        if (i == 0 && j == 0) {
                            d = d2 = d3;
                            continue;
                        }
                        if (d3 < d) {
                            d = d3;
                        }
                        if (!(d3 > d2)) continue;
                        d2 = d3;
                    }
                }
                this.maxDepth = d2 - d;
                if (d < 0.0) {
                    this.minDepthPt = this.depthDir.dup().len(d).add(this.minDepthPt);
                }
            }
        }

        public double getDepth(double d, double d2) {
            return this.getDepth(this.surface.pt(d, d2).get());
        }

        public double getDepth(IVec iVec) {
            IVec iVec2 = iVec.diff(this.minDepthPt);
            return this.depthDir.dot(iVec2);
        }

        public double get(double d, double d2) {
            IVec iVec = this.surface.pt(d, d).get().diff(this.minDepthPt);
            return this.depthDir.dot(iVec) / this.maxDepth;
        }
    }

    public static class SurfaceDensityMap
    extends IMap {
        public ISurfaceI surface;
        public IVec orig;
        public IVec uvec;
        public IVec vvec;

        public SurfaceDensityMap(ISurfaceI iSurfaceI) {
            this.surface = iSurfaceI;
            this.initMap();
        }

        public void initMap() {
            this.orig = this.surface.corner(0, 0).get();
            this.uvec = this.surface.corner(1, 0).diff(this.orig).get();
            this.vvec = this.surface.corner(0, 1).diff(this.orig).get();
        }

        public void initDensityMapU(int n, int n2) {
        }

        public double projectU(double d, double d2) {
            IVec iVec = this.surface.pt(d, d2).get();
            iVec.sub(this.orig);
            double[] dArray = iVec.projectTo2Vec(this.uvec, this.vvec);
            return dArray[0];
        }

        public double projectV(double d, double d2) {
            IVec iVec = this.surface.pt(d, d2).get();
            iVec.sub(this.orig);
            double[] dArray = iVec.projectTo2Vec(this.uvec, this.vvec);
            return dArray[1];
        }

        public IVec2 project(double d, double d2) {
            IVec iVec = this.surface.pt(d, d2).get();
            iVec.sub(this.orig);
            double[] dArray = iVec.projectTo2Vec(this.uvec, this.vvec);
            return new IVec2(dArray[0], dArray[1]);
        }
    }

    public static class ImageMap
    extends DoubleMap {
        public Image image;

        public ImageMap(String string) {
            this.initMap(string);
        }

        public ImageMap(Image image) {
            this.initMap(image);
        }

        public ImageMap(String string, Component component) {
            this.initMap(string, component);
        }

        public void initMap(String string) {
            this.initMap(IImageLoader.getImage(string));
        }

        public void initMap(String string, Component component) {
            this.initMap(IImageLoader.getImage(string, component));
        }

        public void initMap(Image image) {
            this.image = image;
            this.width = image.getWidth(IImageLoader.observer);
            this.height = image.getHeight(IImageLoader.observer);
            int[] nArray = new int[this.width * this.height];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, nArray, 0, this.width);
            if (pixelGrabber != null) {
                try {
                    pixelGrabber.grabPixels();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            super.initMap(this.width, this.height);
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    super.set(j, i, ImageMap.getColorValue(nArray, j, i, this.width));
                }
            }
        }

        public static double getColorValue(int[] nArray, int n, int n2, int n3) {
            int[] nArray2 = new int[4];
            int n4 = nArray[n3 * n2 + n];
            nArray2[0] = n4 >> 24 & 0xFF;
            nArray2[1] = n4 >> 16 & 0xFF;
            nArray2[2] = n4 >> 8 & 0xFF;
            nArray2[3] = n4 & 0xFF;
            return (double)(nArray2[1] + nArray2[2] + nArray2[3]) / 765.0 * ((double)nArray2[0] / 255.0);
        }

        public void initDensityMapU() {
            this.initDensityMapU(this.width, this.height);
        }

        public void initDensityMapV() {
            this.initDensityMapV(this.width, this.height);
        }
    }

    public static class VSineMap
    extends IMap {
        public double minValue;
        public double maxValue;
        public double frequency;
        public double phase;

        public VSineMap(double d, double d2, double d3, double d4) {
            this.minValue = d;
            this.maxValue = d2;
            this.frequency = d3;
            this.phase = d4;
        }

        public double get(double d, double d2) {
            return this.get(d2);
        }

        public double get(double d) {
            return (Math.sin((d - this.phase) * this.frequency * 2.0 * Math.PI) + 1.0) / 2.0 * (this.maxValue - this.minValue) + this.minValue;
        }
    }

    public static class USineMap
    extends IMap {
        public double minValue;
        public double maxValue;
        public double frequency;
        public double phase;

        public USineMap(double d, double d2, double d3, double d4) {
            this.minValue = d;
            this.maxValue = d2;
            this.frequency = d3;
            this.phase = d4;
        }

        public double get(double d, double d2) {
            return this.get(d);
        }

        public double get(double d) {
            return (Math.sin((d - this.phase) * 2.0 * Math.PI * this.frequency) + 1.0) / 2.0 * (this.maxValue - this.minValue) + this.minValue;
        }
    }

    public static class VPiecewiseLinearMap
    extends IMap {
        public ArrayList<Double> domains = new ArrayList();
        public ArrayList<Double> values = new ArrayList();

        public void addValue(double d, double d2) {
            this.domains.add(d);
            this.values.add(d2);
        }

        public double get(double d, double d2) {
            return this.get(d2);
        }

        public double get(double d) {
            if (this.domains.size() == 0) {
                return 0.0;
            }
            if (d <= this.domains.get(0)) {
                return this.values.get(0);
            }
            for (int i = 0; i < this.domains.size() - 1; ++i) {
                if (!(d >= this.domains.get(i)) || !(d < this.domains.get(i + 1))) continue;
                return (this.values.get(i + 1) - this.values.get(i)) * (d - this.domains.get(i)) / (this.domains.get(i + 1) - this.domains.get(i)) + this.values.get(i);
            }
            return this.values.get(this.values.size() - 1);
        }

        public void flipV() {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (int i = this.domains.size() - 1; i >= 0; --i) {
                arrayList.add(1.0 - this.domains.get(i));
                arrayList2.add(this.values.get(i));
            }
            this.domains = arrayList;
            this.values = arrayList2;
        }
    }

    public static class UPiecewiseLinearMap
    extends IMap {
        public ArrayList<Double> domains = new ArrayList();
        public ArrayList<Double> values = new ArrayList();

        public void addValue(double d, double d2) {
            this.domains.add(d);
            this.values.add(d2);
        }

        public double get(double d, double d2) {
            return this.get(d);
        }

        public double get(double d) {
            if (this.domains.size() == 0) {
                return 0.0;
            }
            if (d <= this.domains.get(0)) {
                return this.values.get(0);
            }
            for (int i = 0; i < this.domains.size() - 1; ++i) {
                if (!(d >= this.domains.get(i)) || !(d < this.domains.get(i + 1))) continue;
                return (this.values.get(i + 1) - this.values.get(i)) * (d - this.domains.get(i)) / (this.domains.get(i + 1) - this.domains.get(i)) + this.values.get(i);
            }
            return this.values.get(this.values.size() - 1);
        }

        public void flipU() {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (int i = this.domains.size() - 1; i >= 0; --i) {
                arrayList.add(1.0 - this.domains.get(i));
                arrayList2.add(this.values.get(i));
            }
            this.domains = arrayList;
            this.values = arrayList2;
        }
    }

    public static class VLinearMap
    extends IMap {
        public double vval1;
        public double vval2;

        public VLinearMap(double d, double d2) {
            this.vval1 = d;
            this.vval2 = d2;
        }

        public double get(double d, double d2) {
            return (this.vval2 - this.vval1) * d2 + this.vval1;
        }

        public void flipV() {
            double d = this.vval1;
            this.vval1 = this.vval2;
            this.vval2 = d;
        }
    }

    public static class ULinearMap
    extends IMap {
        public double uval1;
        public double uval2;

        public ULinearMap(double d, double d2) {
            this.uval1 = d;
            this.uval2 = d2;
        }

        public double get(double d, double d2) {
            return (this.uval2 - this.uval1) * d + this.uval1;
        }

        public void flipU() {
            double d = this.uval1;
            this.uval1 = this.uval2;
            this.uval2 = d;
        }
    }

    public static class DoubleMap
    extends IMap {
        public boolean interpolation = true;
        public int width;
        public int height;
        public double[][] map;

        public DoubleMap() {
        }

        public DoubleMap(int n, int n2) {
            this.initMap(n, n2);
        }

        public void initMap(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.map = new double[n][n2];
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void set(int n, int n2, double d) {
            this.map[n][n2] = d;
        }

        public void setInterpolation(boolean bl) {
            this.interpolation = bl;
        }

        public double get(double d, double d2) {
            if (this.interpolation) {
                int n = (int)((double)(this.width - 1) * d);
                int n2 = (int)((double)(this.height - 1) * d2);
                if (n < 0) {
                    n = 0;
                } else if (n >= this.width) {
                    n = this.width - 1;
                }
                if (n2 < 0) {
                    n2 = 0;
                } else if (n2 >= this.height) {
                    n2 = this.height - 1;
                }
                double d3 = (double)n / (double)(this.width - 1) - d;
                double d4 = (double)n2 / (double)(this.height - 1) - d2;
                if (d3 == 0.0 || n == this.width - 1) {
                    if (d4 == 0.0 || n2 == this.height - 1) {
                        return this.map[n][n2];
                    }
                    return this.map[n][n2] * (1.0 - d4) + this.map[n][n2 + 1] * d4;
                }
                if (d4 == 0.0 || n2 == this.height - 1) {
                    return this.map[n][n2] * (1.0 - d3) + this.map[n + 1][n2] * d3;
                }
                return (this.map[n][n2] * (1.0 - d3) + this.map[n + 1][n2] * d3) * (1.0 - d4) + (this.map[n][n2 + 1] * (1.0 - d3) + this.map[n + 1][n2 + 1] * d3) * d4;
            }
            int n = (int)((double)(this.width - 1) * d + 0.5);
            int n3 = (int)((double)(this.height - 1) * d2 + 0.5);
            if (n < 0) {
                n = 0;
            } else if (n >= this.width) {
                n = this.width - 1;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 >= this.height) {
                n3 = this.height - 1;
            }
            return this.map[n][n3];
        }

        public void flipU() {
            double[][] dArray = new double[this.width][this.height];
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    dArray[i][j] = this.map[this.width - i - 1][j];
                }
            }
            this.map = dArray;
        }

        public void flipV() {
            double[][] dArray = new double[this.width][this.height];
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    dArray[i][j] = this.map[i][this.height - j - 1];
                }
            }
            this.map = dArray;
        }

        public void scale(double d) {
            for (int i = 0; i < this.width; ++i) {
                int n = 0;
                while (n < this.height) {
                    double[] dArray = this.map[i];
                    int n2 = n++;
                    dArray[n2] = dArray[n2] * d;
                }
            }
        }

        public void add(double d) {
            for (int i = 0; i < this.width; ++i) {
                int n = 0;
                while (n < this.height) {
                    double[] dArray = this.map[i];
                    int n2 = n++;
                    dArray[n2] = dArray[n2] + d;
                }
            }
        }
    }
}

