/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IServerI;
import igeo.geo.IBool;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.IEntityParameter;
import igeo.geo.IMatrix3I;
import igeo.geo.IMatrix4I;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.geo.IVec4I;
import igeo.geo.IVecI;

public class IVec4
extends IVec
implements IVec4I,
IEntityParameter {
    public double w;

    public IVec4() {
    }

    public IVec4(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public IVec4(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = 1.0;
    }

    public IVec4(IVec4 iVec4) {
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
    }

    public IVec4(IVec4I iVec4I) {
        IVec4 iVec4 = iVec4I.get();
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
    }

    public IVec4(IVec iVec) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = 1.0;
    }

    public IVec4(IVecI iVecI) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = 1.0;
    }

    public IVec4(IVec iVec, double d) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
    }

    public IVec4(IVecI iVecI, double d) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
    }

    public IVec4(IVecI iVecI, IDoubleI iDoubleI) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = iDoubleI.x();
    }

    public IVec4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        this.w = iDoubleI4.x();
    }

    public IVec4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        this.w = 1.0;
    }

    public IVec4(IServerI iServerI) {
        super(iServerI);
    }

    public IVec4(IServerI iServerI, double d, double d2, double d3, double d4) {
        super(iServerI);
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public IVec4(IServerI iServerI, double d, double d2, double d3) {
        super(iServerI);
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = 1.0;
    }

    public IVec4(IServerI iServerI, IVec4 iVec4) {
        super(iServerI);
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
    }

    public IVec4(IServerI iServerI, IVec4I iVec4I) {
        super(iServerI);
        IVec4 iVec4 = iVec4I.get();
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
    }

    public IVec4(IServerI iServerI, IVec iVec) {
        super(iServerI);
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = 1.0;
    }

    public IVec4(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = 1.0;
    }

    public IVec4(IServerI iServerI, IVec iVec, double d) {
        super(iServerI);
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
    }

    public IVec4(IServerI iServerI, IVecI iVecI, double d) {
        super(iServerI);
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
    }

    public IVec4(IServerI iServerI, IVecI iVecI, IDoubleI iDoubleI) {
        super(iServerI);
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = iDoubleI.x();
    }

    public IVec4(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        super(iServerI);
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        this.w = iDoubleI4.x();
    }

    public IVec4(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super(iServerI);
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        this.w = 1.0;
    }

    public double w() {
        return this.w;
    }

    public IVec4 get() {
        return new IVec4(this.x, this.y, this.z, this.w);
    }

    public IVec4 dup() {
        return new IVec4(this.x, this.y, this.z, this.w);
    }

    public IVec to3d() {
        return new IVec(this);
    }

    public IVec2 to2d() {
        return new IVec2(this);
    }

    public IVec4 to4d() {
        return new IVec4(this);
    }

    public IVec4 to4d(double d) {
        return new IVec4(this, d);
    }

    public IVec4 to4d(IDoubleI iDoubleI) {
        return new IVec4((IVecI)this, iDoubleI);
    }

    public IDouble getW() {
        return new IDouble(this.w);
    }

    public IVec4 set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
        return this;
    }

    public IVec4 set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        this.w = iDoubleI4.x();
        return this;
    }

    public IVec4 set(IVec4 iVec4) {
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
        return this;
    }

    public IVec4 set(IVec iVec, double d) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
        return this;
    }

    public IVec4 set(IVec4I iVec4I) {
        IVec4 iVec4 = iVec4I.get();
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
        return this;
    }

    public IVec4 set(IVecI iVecI, double d) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
        return this;
    }

    public IVec4 set(IVecI iVecI, IDoubleI iDoubleI) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = iDoubleI.x();
        return this;
    }

    public IVec4 set(IVec iVec) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        return this;
    }

    public IVec4 set(IVecI iVecI) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        return this;
    }

    public IVec4 set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public IVec4 set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        return this;
    }

    public IVec4 add(double d, double d2, double d3) {
        super.add(d, d2, d3);
        return this;
    }

    public IVec4 add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVec4 add(IVec iVec) {
        super.add(iVec);
        return this;
    }

    public IVec4 add(IVecI iVecI) {
        super.add(iVecI);
        return this;
    }

    public IVec4 sub(double d, double d2, double d3) {
        super.sub(d, d2, d3);
        return this;
    }

    public IVec4 sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVec4 sub(IVec iVec) {
        super.sub(iVec);
        return this;
    }

    public IVec4 sub(IVecI iVecI) {
        super.sub(iVecI);
        return this;
    }

    public IVec4 mul(IDoubleI iDoubleI) {
        super.mul(iDoubleI);
        return this;
    }

    public IVec4 mul(double d) {
        super.mul(d);
        return this;
    }

    public IVec4 div(IDoubleI iDoubleI) {
        super.div(iDoubleI);
        return this;
    }

    public IVec4 div(double d) {
        super.div(d);
        return this;
    }

    public IVec4 neg() {
        super.neg();
        return this;
    }

    public IVec4 rev() {
        super.rev();
        return this;
    }

    public IVec4 add(IVec iVec, double d) {
        super.add(iVec, d);
        return this;
    }

    public IVec4 add(IVecI iVecI, double d) {
        super.add(iVecI, d);
        return this;
    }

    public IVec4 add(IVecI iVecI, IDoubleI iDoubleI) {
        super.add(iVecI, iDoubleI);
        return this;
    }

    public IVec4 len(IDoubleI iDoubleI) {
        super.len(iDoubleI);
        return this;
    }

    public IVec4 len(double d) {
        super.len(d);
        return this;
    }

    public IVec4 unit() {
        super.unit();
        return this;
    }

    public IVec4 cross(IVec iVec) {
        return this.dup().set(this.y * iVec.z - this.z * iVec.y, this.z * iVec.x - this.x * iVec.z, this.x * iVec.y - this.y * iVec.x);
    }

    public IVec4 cross(IVecI iVecI) {
        return this.cross(iVecI.get());
    }

    public boolean eqW(IVec4I iVec4I) {
        return this.eqW(iVec4I, IConfig.lengthResolution);
    }

    public boolean eqW(IVec4I iVec4I, double d) {
        return Math.abs(this.w - iVec4I.w()) <= d;
    }

    public boolean eqW(IVec4 iVec4, double d) {
        return Math.abs(this.w - iVec4.w) <= d;
    }

    public boolean eqW(ISwitchE iSwitchE, IVec4I iVec4I) {
        return this.eqW(iVec4I);
    }

    public boolean eqW(ISwitchE iSwitchE, IVec4I iVec4I, double d) {
        return this.eqW(iVec4I, d);
    }

    public IBool eqW(ISwitchR iSwitchR, IVec4I iVec4I) {
        return new IBool(this.eqW(iVec4I));
    }

    public IBool eqW(ISwitchR iSwitchR, IVec4I iVec4I, IDoubleI iDoubleI) {
        return new IBool(this.eqW(iVec4I, iDoubleI.x()));
    }

    public IVec4 rot(IVecI iVecI, IDoubleI iDoubleI) {
        super.rot(iVecI, iDoubleI);
        return this;
    }

    public IVec4 rot(IVecI iVecI, double d) {
        super.rot(iVecI, d);
        return this;
    }

    public IVec4 rot(IVec iVec, double d) {
        super.rot(iVec, d);
        return this;
    }

    public IVec4 rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        super.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IVec4 rot(IVecI iVecI, IVecI iVecI2, double d) {
        super.rot(iVecI, iVecI2, d);
        return this;
    }

    public IVec4 rot(IVec iVec, IVec iVec2, double d) {
        super.rot(iVec, iVec2, d);
        return this;
    }

    public IVec4 rot(IVec iVec, IVec iVec2) {
        super.rot(iVec, iVec2);
        return this;
    }

    public IVec4 rot(IVecI iVecI, IVecI iVecI2) {
        super.rot(iVecI, iVecI2);
        return this;
    }

    public IVec4 rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IVec4 rot(IVec iVec, IVec iVec2, IVec iVec3) {
        super.rot(iVec, iVec2, iVec3);
        return this;
    }

    public IVec4 scale(IDoubleI iDoubleI) {
        super.scale(iDoubleI);
        return this;
    }

    public IVec4 scale(double d) {
        super.scale(d);
        return this;
    }

    public IVec4 scale(IVecI iVecI, IDoubleI iDoubleI) {
        super.scale(iVecI, iDoubleI);
        return this;
    }

    public IVec4 scale(IVecI iVecI, double d) {
        super.scale(iVecI, d);
        return this;
    }

    public IVec4 scale(IVec iVec, double d) {
        super.scale(iVec, d);
        return this;
    }

    public IVec4 mirror(IVec iVec) {
        super.mirror(iVec);
        return this;
    }

    public IVec4 mirror(IVecI iVecI) {
        super.mirror(iVecI);
        return this;
    }

    public IVec4 mirror(IVec iVec, IVec iVec2) {
        super.mirror(iVec, iVec2);
        return this;
    }

    public IVec4 mirror(IVecI iVecI, IVecI iVecI2) {
        super.mirror(iVecI, iVecI2);
        return this;
    }

    public IVec4 transform(IMatrix3I iMatrix3I) {
        super.transform(iMatrix3I);
        return this;
    }

    public IVec4 transform(IMatrix4I iMatrix4I) {
        super.transform(iMatrix4I);
        return this;
    }

    public IVec4 transform(IVec iVec, IVec iVec2, IVec iVec3) {
        super.transform(iVec, iVec2, iVec3);
        return this;
    }

    public IVec4 transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IVec4 transform(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4) {
        super.transform(iVec, iVec2, iVec3, iVec4);
        return this;
    }

    public IVec4 transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        super.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    public IVec4 diff(IVec iVec) {
        return this.dup().sub(iVec);
    }

    public IVec4 diff(IVecI iVecI) {
        return this.dup().sub(iVecI);
    }

    public IVec4 mid(IVec iVec) {
        return this.dup().add(iVec).div(2.0);
    }

    public IVec4 mid(IVecI iVecI) {
        return this.dup().add(iVecI).div(2.0);
    }

    public IVec4 sum(IVec iVec) {
        return this.dup().add(iVec);
    }

    public IVec4 sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVec4 sum(IVec ... iVecArray) {
        IVec4 iVec4 = this.dup();
        for (IVec iVec : iVecArray) {
            iVec4.add(iVec);
        }
        return iVec4;
    }

    public IVec4 sum(IVecI ... iVecIArray) {
        IVec4 iVec4 = this.dup();
        for (IVecI iVecI : iVecIArray) {
            iVec4.add(iVecI);
        }
        return iVec4;
    }

    public IVec4 bisect(IVec iVec) {
        return this.dup().unit().add(iVec.dup().unit());
    }

    public IVec4 bisect(IVecI iVecI) {
        return this.bisect(iVecI.get());
    }

    public IVec4 sum(IVec iVec, double d, double d2) {
        return this.dup().mul(d).add(iVec, d2);
    }

    public IVec4 sum(IVec iVec, double d) {
        return this.dup().mul(1.0 - d).add(iVec, d);
    }

    public IVec4 sum(IVecI iVecI, double d, double d2) {
        return this.sum(iVecI.get(), d, d2);
    }

    public IVec4 sum(IVecI iVecI, double d) {
        return this.sum(iVecI, d);
    }

    public IVec4 sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.sum(iVecI.get(), iDoubleI.x(), iDoubleI2.x());
    }

    public IVec4 sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.sum(iVecI.get(), iDoubleI.x());
    }

    public String toString() {
        return "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + "," + String.valueOf(this.z) + "," + String.valueOf(this.w) + ")";
    }
}

