/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.IGraphicObject;
import igeo.core.IMaterial;
import igeo.core.IObject;
import igeo.core.IServerI;
import java.awt.Color;
import java.util.ArrayList;

public class ILayer
extends IObject {
    public ArrayList<IObject> objects = new ArrayList();
    public Color color;
    public IMaterial material;
    public boolean visible = true;

    public ILayer() {
    }

    public ILayer(String string) {
        this();
        this.name = string;
    }

    public ILayer(IServerI iServerI) {
        super(iServerI);
    }

    public ILayer(IServerI iServerI, String string) {
        this(iServerI);
        this.name = string;
    }

    public int num() {
        return this.objects.size();
    }

    public IObject get(int n) {
        return this.objects.get(n);
    }

    public ILayer add(IObject iObject) {
        if (!this.objects.contains(iObject)) {
            this.objects.add(iObject);
            if (iObject.layer() != this) {
                iObject.layer(this);
            }
        }
        return this;
    }

    public ILayer remove(int n) {
        this.objects.remove(n);
        return this;
    }

    public ILayer remove(IObject iObject) {
        this.objects.remove(iObject);
        return this;
    }

    public boolean contains(IObject iObject) {
        return this.objects.contains(iObject);
    }

    public ILayer name(String string) {
        this.name = string;
        return this;
    }

    public boolean visible() {
        return this.visible;
    }

    public ILayer setVisible(boolean bl) {
        return this.visible(bl);
    }

    public ILayer visible(boolean bl) {
        this.visible = bl;
        if (this.visible) {
            this.show();
        } else {
            this.hide();
        }
        return this;
    }

    public ILayer hide() {
        super.hide();
        for (IObject iObject : this.objects) {
            iObject.hide();
        }
        return this;
    }

    public ILayer show() {
        super.show();
        for (IObject iObject : this.objects) {
            iObject.show();
        }
        return this;
    }

    public Color clr() {
        return this.color;
    }

    public ILayer clr(Color color) {
        this.color = color;
        return this;
    }

    public ILayer clr(int n) {
        this.color = IGraphicObject.getColor(n);
        return this;
    }

    public ILayer clr(float f) {
        this.color = IGraphicObject.getColor(f);
        return this;
    }

    public ILayer clr(double d) {
        this.clr((float)d);
        return this;
    }

    public ILayer clr(int n, int n2) {
        this.color = IGraphicObject.getColor(n, n2);
        return this;
    }

    public ILayer clr(float f, float f2) {
        this.color = IGraphicObject.getColor(f, f2);
        return this;
    }

    public ILayer clr(double d, double d2) {
        this.clr((float)d, (float)d2);
        return this;
    }

    public ILayer clr(int n, int n2, int n3) {
        this.color = IGraphicObject.getColor(n, n2, n3);
        return this;
    }

    public ILayer clr(float f, float f2, float f3) {
        this.color = IGraphicObject.getColor(f, f2, f3);
        return this;
    }

    public ILayer clr(double d, double d2, double d3) {
        this.clr((float)d, (float)d2, (float)d3);
        return this;
    }

    public ILayer clr(int n, int n2, int n3, int n4) {
        this.color = IGraphicObject.getColor(n, n2, n3, n4);
        return this;
    }

    public ILayer clr(float f, float f2, float f3, float f4) {
        this.color = IGraphicObject.getColor(f, f2, f3, f4);
        return this;
    }

    public ILayer clr(double d, double d2, double d3, double d4) {
        this.clr((float)d, (float)d2, (float)d3, (float)d4);
        return this;
    }

    public ILayer hsb(float f, float f2, float f3, float f4) {
        this.color = IGraphicObject.getHSBColor(f, f2, f3, f4);
        return this;
    }

    public ILayer hsb(double d, double d2, double d3, double d4) {
        this.hsb((float)d, (float)d2, (float)d3, (float)d4);
        return this;
    }

    public ILayer hsb(float f, float f2, float f3) {
        this.color = IGraphicObject.getHSBColor(f, f2, f3);
        return this;
    }

    public ILayer hsb(double d, double d2, double d3) {
        this.hsb((float)d, (float)d2, (float)d3);
        return this;
    }

    public Color getColor() {
        return this.clr();
    }

    public ILayer setColor(Color color) {
        return this.clr(color);
    }

    public ILayer setColor(int n) {
        return this.clr(n);
    }

    public ILayer setColor(float f) {
        return this.clr(f);
    }

    public ILayer setColor(double d) {
        return this.clr(d);
    }

    public ILayer setColor(int n, int n2) {
        return this.clr(n, n2);
    }

    public ILayer setColor(float f, float f2) {
        return this.clr(f, f2);
    }

    public ILayer setColor(double d, double d2) {
        return this.clr(d, d2);
    }

    public ILayer setColor(int n, int n2, int n3) {
        return this.clr(n, n2, n3);
    }

    public ILayer setColor(float f, float f2, float f3) {
        return this.clr(f, f2, f3);
    }

    public ILayer setColor(double d, double d2, double d3) {
        return this.clr(d, d2, d3);
    }

    public ILayer setColor(int n, int n2, int n3, int n4) {
        return this.clr(n, n2, n3, n4);
    }

    public ILayer setColor(float f, float f2, float f3, float f4) {
        return this.clr(f, f2, f3, f4);
    }

    public ILayer setColor(double d, double d2, double d3, double d4) {
        return this.clr(d, d2, d3, d4);
    }

    public ILayer setHSBColor(float f, float f2, float f3, float f4) {
        return this.hsb(f, f2, f3, f4);
    }

    public ILayer setHSBColor(double d, double d2, double d3, double d4) {
        return this.hsb(d, d2, d3, d4);
    }

    public ILayer setHSBColor(float f, float f2, float f3) {
        return this.hsb(f, f2, f3);
    }

    public ILayer setHSBColor(double d, double d2, double d3) {
        return this.hsb(d, d2, d3);
    }

    public ILayer setMaterial(IMaterial iMaterial) {
        this.material = iMaterial;
        return this;
    }
}

